/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.Config;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.base.IAttachment;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.pump.TilePump;
import com.yogpc.qp.machines.quarry.TileBasic;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.utils.Holder;
import java.util.Map;
import java.util.Optional;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import scala.Symbol;

public class TileMiningWell
extends TileBasic
implements ITickable {
    public static final Symbol SYMBOL = Symbol.apply((String)"MiningwellPlus");
    private boolean working;

    public TileMiningWell() {
        super(Holder.miningWellTileType());
    }

    @Override
    public void G_renew_powerConfigure() {
        int pmp = 0;
        if (this.func_145830_o()) {
            Map map = this.facingMap.entrySet().stream().filter(MapStreamSyntax.byEntry((attachments, facing) -> attachments.test(this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing))))).collect(MapStreamSyntax.entryToMap());
            this.facingMap.putAll(map);
            pmp = Optional.ofNullable(this.facingMap.get(IAttachment.Attachments.FLUID_PUMP)).map(arg_0 -> ((BlockPos)this.func_174877_v()).func_177972_a(arg_0)).map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).flatMap(IAttachment.Attachments.FLUID_PUMP).map(p -> p.unbreaking).orElse((byte)0).byteValue();
        }
        if (this.working) {
            PowerManager.configureMiningWell(this, this.efficiency, this.unbreaking, pmp);
        } else {
            PowerManager.configure0(this);
        }
    }

    public TextComponentString getName() {
        return new TextComponentString("block.quarryplus.miningwellplus");
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            int depth = this.func_174877_v().func_177956_o() - 1;
            while (!this.S_checkTarget(depth)) {
                BlockPos pos = new BlockPos(this.func_174877_v().func_177958_n(), depth, this.func_174877_v().func_177952_p());
                if (this.working && (((Boolean)Config.common().removeBedrock().get()).booleanValue() || this.field_145850_b.func_180495_p(pos).func_185887_b((IBlockReader)this.field_145850_b, pos) >= 0.0f)) {
                    this.field_145850_b.func_175656_a(pos, Holder.blockPlainPipe().func_176223_P());
                }
                --depth;
            }
            if (this.working) {
                this.S_breakBlock(this.func_174877_v().func_177958_n(), depth, this.func_174877_v().func_177952_p(), Blocks.field_150350_a.func_176223_P());
            }
            this.S_pollItems();
        }
    }

    @Override
    protected boolean isWorking() {
        return this.working;
    }

    private boolean S_checkTarget(int depth) {
        if (depth < this.yLevel) {
            this.G_destroy();
            this.finishWork();
            return true;
        }
        BlockPos pos = new BlockPos(this.func_174877_v().func_177958_n(), depth, this.func_174877_v().func_177952_p());
        IBlockState b = this.field_145850_b.func_180495_p(pos);
        float h = b.func_185887_b((IBlockReader)this.field_145850_b, pos);
        if (h < 0.0f || b.func_177230_c() == Holder.blockPlainPipe() || b.func_177230_c().isAir(b, (IBlockReader)this.field_145850_b, pos)) {
            return false;
        }
        if (!this.facingMap.containsKey(IAttachment.Attachments.FLUID_PUMP) && TilePump.isLiquid(b)) {
            return false;
        }
        if (!this.working) {
            this.G_ReInit();
        }
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setWorking(nbt.func_74767_n("working"));
        this.G_renew_powerConfigure();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("working", this.working);
        return super.func_189515_b(nbt);
    }

    @Override
    public void G_ReInit() {
        this.setWorking(true);
        this.G_renew_powerConfigure();
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.sendToAround(TileMessage.create(this), this.field_145850_b, this.func_174877_v());
        }
    }

    @Override
    protected void G_destroy() {
        if (!this.field_145850_b.field_72995_K) {
            this.working = false;
            this.G_renew_powerConfigure();
            PacketHandler.sendToAround(TileMessage.create(this), this.field_145850_b, this.func_174877_v());
            this.removePipes();
        }
    }

    public void removePipes() {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.func_174877_v());
        for (int depth = this.func_174877_v().func_177956_o() - 1; depth > 0; --depth) {
            pos.func_185336_p(depth);
            if (this.field_145850_b.func_180495_p((BlockPos)pos).func_177230_c() != Holder.blockPlainPipe()) break;
            this.field_145850_b.func_175698_g((BlockPos)pos);
        }
    }

    private void setWorking(boolean working) {
        this.working = working;
        if (working) {
            this.startWork();
        }
        if (this.func_145830_o()) {
            IBlockState old = this.field_145850_b.func_180495_p(this.func_174877_v());
            InvUtils.setNewState(this.field_145850_b, this.func_174877_v(), this, (IBlockState)old.func_206870_a((IProperty)QPBlock.WORKING(), (Comparable)Boolean.valueOf(working)));
        }
    }

    @Override
    protected Symbol getSymbol() {
        return SYMBOL;
    }
}

