/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.replacer;

import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.machines.base.APacketTile;
import com.yogpc.qp.machines.base.IAttachable;
import com.yogpc.qp.machines.base.IAttachment;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.pump.TilePump;
import com.yogpc.qp.utils.Holder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockReader;
import org.apache.commons.lang3.tuple.Pair;
import scala.Symbol;

public class TileReplacer
extends APacketTile
implements IAttachment {
    public static final Symbol SYMBOL = Symbol.apply((String)"Replacer");
    private static final List<Predicate<IBlockState>> rejects = new ArrayList<Predicate>(Arrays.asList(state -> state.func_177230_c().hasTileEntity(state), state -> state.func_185904_a() == Material.field_151594_q, TilePump::isLiquid, MapStreamSyntax.always_false()));
    private EnumFacing facing;
    private boolean loading = false;
    private IBlockState toReplaceState = Blocks.field_150350_a.func_176223_P();

    public TileReplacer() {
        super(Holder.replacerType());
    }

    @Override
    protected Symbol getSymbol() {
        return SYMBOL;
    }

    public void onLoad() {
        super.onLoad();
        if (this.loading) {
            this.loading = false;
            this.connection();
        }
    }

    public void neighborChanged() {
        this.connection();
    }

    public void onPlaced() {
        this.connection();
    }

    private void connection() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            Map.Entry<EnumFacing, IAttachable> entry = Stream.of(EnumFacing.values()).map(f -> Pair.of((Object)f, (Object)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f)))).filter(MapStreamSyntax.byValue(IAttachable.class::isInstance)).map(MapStreamSyntax.values(IAttachable.class::cast)).filter(MapStreamSyntax.byEntry((facing, t) -> t.connect(facing.func_176734_d(), IAttachment.Attachments.REPLACER))).findFirst().orElse((Map.Entry<EnumFacing, IAttachable>)Pair.of(null, (Object)IAttachable.dummy));
            if (entry.getKey() == null || entry.getValue().connectAttachment(entry.getKey().func_176734_d(), IAttachment.Attachments.REPLACER, false)) {
                this.setConnectTo(entry.getKey());
            }
            Predicate accept = rejects.stream().reduce(MapStreamSyntax.always_false(), Predicate::or).negate();
            this.toReplaceState = Optional.of(this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a())).filter(s -> !s.isAir((IBlockReader)this.field_145850_b, this.field_174879_c.func_177984_a())).filter(accept).orElse(Holder.blockDummy().func_176223_P());
        }
    }

    @Override
    public void setConnectTo(@Nullable EnumFacing facing) {
        IBlockState state;
        this.facing = facing;
        if (this.func_145830_o() && facing != null ^ (Boolean)(state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177229_b((IProperty)QPBlock.WORKING())) {
            InvUtils.setNewState(this.field_145850_b, this.field_174879_c, this, (IBlockState)state.func_206870_a((IProperty)QPBlock.WORKING(), (Comparable)Boolean.valueOf(facing != null)));
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        compound.func_74778_a("facing", Optional.ofNullable(this.facing).map(Enum::name).orElse(""));
        this.loading = true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.facing = Optional.of(compound.func_74779_i("facing")).filter(MapStreamSyntax.not(String::isEmpty)).map(EnumFacing::func_176739_a).orElse(null);
        return super.func_189515_b(compound);
    }

    public IBlockState getReplaceState() {
        return this.toReplaceState;
    }
}

