/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.yogpc.qp.Config;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.machines.base.APowerTile;
import com.yogpc.qp.machines.base.EnergyUsage;
import com.yogpc.qp.machines.base.HasInv;
import com.yogpc.qp.machines.base.IDebugSender;
import com.yogpc.qp.machines.workbench.ContainerWorkbench;
import com.yogpc.qp.machines.workbench.IngredientWithCount;
import com.yogpc.qp.machines.workbench.WorkbenchRecipes;
import com.yogpc.qp.utils.Holder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import scala.Symbol;

public class TileWorkbench
extends APowerTile
implements HasInv,
IDebugSender,
IInteractionObject {
    public static final String GUI_ID = "quarryplus:gui_workbenchplus";
    public final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    public final NonNullList<ItemStack> inventory2 = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
    public List<WorkbenchRecipes> recipesList = Collections.emptyList();
    private WorkbenchRecipes currentRecipe = WorkbenchRecipes.dummyRecipe();
    private ItemHandler itemHandler = new ItemHandler();
    public boolean workContinue;

    public TileWorkbench() {
        super(Holder.workbenchTileType());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.isWorking() && (this.currentRecipe.microEnergy() <= this.getStoredEnergy() || ((Boolean)Config.common().noEnergy().get()).booleanValue())) {
            this.useEnergy(this.currentRecipe.microEnergy(), this.currentRecipe.microEnergy(), true, EnergyUsage.WORKBENCH);
            ItemStack stack = this.currentRecipe.getOutput();
            ItemStack inserted = InvUtils.injectToNearTile(this.field_145850_b, this.func_174877_v(), stack);
            if (!inserted.func_190926_b()) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (ItemStack)stack);
            }
            this.currentRecipe.inputsJ().forEach(inputList -> {
                for (IngredientWithCount i : inputList) {
                    if (!this.inventory.stream().anyMatch(i::shrink)) continue;
                    break;
                }
            });
            for (int i = 0; i < this.inventory.size(); ++i) {
                if (!((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                this.inventory.set(i, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            this.setCurrentRecipeIndex(this.workContinue ? this.getRecipeIndex() : -1);
        }
    }

    @Override
    public boolean isWorking() {
        return this.currentRecipe.hasContent();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        list.stream().map(b -> (NBTTagCompound)b).forEach(nbtTagCompound -> {
            int j = nbtTagCompound.func_74771_c("Slot") & 0xFF;
            ItemStack stack = ItemStack.func_199557_a((NBTTagCompound)nbtTagCompound);
            stack.func_190920_e(nbtTagCompound.func_74762_e("Count"));
            this.inventory.set(j, (Object)stack);
        });
        this.func_70296_d();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(nbttagcompound);
            nbttagcompound.func_82580_o("Count");
            nbttagcompound.func_74768_a("Count", stack.func_190916_E());
            list.add((INBTBase)nbttagcompound);
        }
        nbt.func_74782_a("Items", (INBTBase)list);
        return super.func_189515_b(nbt);
    }

    @Override
    public int func_70302_i_() {
        return this.inventory.size() + this.inventory2.size();
    }

    @Override
    public boolean func_191420_l() {
        return this.inventory.stream().allMatch(ItemStack::func_190926_b);
    }

    @Override
    public ItemStack func_70301_a(int index) {
        if (this.inventory.size() <= index && index < this.func_70302_i_()) {
            return (ItemStack)this.inventory2.get(index - this.inventory.size());
        }
        return (ItemStack)this.inventory.get(index);
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        if (this.inventory.size() <= index && index < this.func_70302_i_()) {
            return ItemStackHelper.func_188382_a(this.inventory2, (int)(index - this.inventory.size()), (int)count);
        }
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        if (this.inventory.size() <= index && index < this.func_70302_i_()) {
            return ItemStackHelper.func_188383_a(this.inventory2, (int)(index - this.inventory.size()));
        }
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (this.inventory.size() <= index && index < this.func_70302_i_()) {
            this.inventory2.set(index - this.inventory.size(), (Object)stack);
        } else {
            this.inventory.set(index, (Object)stack);
        }
    }

    @Override
    public int func_70297_j_() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b != null && this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_174831_c(this.func_174877_v()) <= 64.0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.recipesList = WorkbenchRecipes.getRecipe(this.inventory);
        this.inventory2.clear();
        for (int i = 0; i < this.recipesList.size(); ++i) {
            this.func_70299_a(this.inventory.size() + i, this.recipesList.get(i).getOutput());
        }
        if (this.getRecipeIndex() == -1) {
            this.setCurrentRecipeIndex(-1);
            this.finishWork();
        } else {
            this.startWork();
        }
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.getRecipeIndex();
            }
            case 1: {
                return 0;
            }
            case 2: {
                return this.workContinue ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.setCurrentRecipeIndex(value);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.workContinue = value == 1;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 3;
    }

    @Override
    public void func_174888_l() {
        this.inventory.clear();
    }

    public List<TextComponentString> getDebugMessages() {
        return Arrays.asList(new TextComponentString(this.currentRecipe.toString()), new TextComponentString("Work mode : " + (this.workContinue ? "Continue" : "Only once")));
    }

    @Override
    public String getDebugName() {
        return "block.quarryplus.workbenchplus";
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.itemHandler));
        }
        return super.getCapability(cap, side);
    }

    public void setCurrentRecipeIndex(int recipeIndex) {
        this.currentRecipe = recipeIndex >= 0 && this.recipesList.size() > recipeIndex ? this.recipesList.get(recipeIndex) : WorkbenchRecipes.dummyRecipe();
        this.configure((long)((Integer)Config.common().workbenchMaxReceive().get()).intValue() * 1000000L, this.currentRecipe.microEnergy());
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressScaled(int scale) {
        if (this.isWorking()) {
            return (int)(this.getStoredEnergy() * (long)scale / this.currentRecipe.microEnergy());
        }
        return 0;
    }

    public int getRecipeIndex() {
        return this.recipesList.indexOf((Object)this.currentRecipe);
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation(this.getDebugName(), new Object[0]);
    }

    @Override
    protected Symbol getSymbol() {
        return Symbol.apply((String)"WorkbenchPlus");
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerWorkbench(playerIn, this);
    }

    public String func_174875_k() {
        return GUI_ID;
    }

    private class ItemHandler
    implements IItemHandlerModifiable {
        private ItemHandler() {
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            TileWorkbench.this.func_70299_a(slot, stack);
        }

        public int getSlots() {
            return TileWorkbench.this.inventory.size();
        }

        public ItemStack getStackInSlot(int slot) {
            return TileWorkbench.this.func_70301_a(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ItemStack inSlot = this.getStackInSlot(slot).func_77946_l();
            if (!inSlot.func_190926_b()) {
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)inSlot, (ItemStack)stack)) {
                    if (!simulate) {
                        inSlot.func_190917_f(stack.func_190916_E());
                        this.setStackInSlot(slot, inSlot);
                        TileWorkbench.this.func_70296_d();
                    }
                    return ItemStack.field_190927_a;
                }
                return stack;
            }
            if (!simulate) {
                this.setStackInSlot(slot, stack.func_77946_l());
                TileWorkbench.this.func_70296_d();
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return TileWorkbench.this.func_70297_j_();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return TileWorkbench.this.func_94041_b(slot, stack);
        }
    }
}

