/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet;

import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.packet.marker.LinkMessage;
import com.yogpc.qp.packet.marker.UpdateBoxMessage;
import com.yogpc.qp.packet.mover.MoverMessage;
import com.yogpc.qp.packet.pump.Mappings;
import com.yogpc.qp.packet.pump.Now;
import com.yogpc.qp.packet.quarry.LevelMessage;
import com.yogpc.qp.packet.quarry.ModeMessage;
import com.yogpc.qp.packet.quarry.MoveHead;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("quarryplus", "main"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        int id = 1;
        INSTANCE.registerMessage(id++, LinkMessage.class, IMessage::writeToBuffer, IMessage.decode(LinkMessage::new), IMessage::onReceiveInternal);
        INSTANCE.registerMessage(id++, UpdateBoxMessage.class, IMessage::writeToBuffer, IMessage.decode(UpdateBoxMessage::new), IMessage::onReceiveInternal);
        INSTANCE.registerMessage(id++, TileMessage.class, IMessage::writeToBuffer, IMessage.decode(TileMessage::new), IMessage::onReceiveInternal);
        INSTANCE.registerMessage(id++, MoverMessage.Move.class, IMessage::writeToBuffer, IMessage.decode(MoverMessage.Move::new), IMessage::onReceiveInternal);
        INSTANCE.registerMessage(id++, MoverMessage.Cursor.class, IMessage::writeToBuffer, IMessage.decode(MoverMessage.Cursor::new), IMessage::onReceiveInternal);
        INSTANCE.registerMessage(id++, LevelMessage.class, IMessage::writeToBuffer, IMessage.decode(LevelMessage::new), IMessage::onReceiveInternal);
        INSTANCE.registerMessage(id++, ModeMessage.class, IMessage::writeToBuffer, IMessage.decode(ModeMessage::new), IMessage::onReceiveInternal);
        INSTANCE.registerMessage(id++, MoveHead.class, IMessage::writeToBuffer, IMessage.decode(MoveHead::new), IMessage::onReceiveInternal);
        INSTANCE.registerMessage(id++, Now.class, IMessage::writeToBuffer, IMessage.decode(Now::new), IMessage::onReceiveInternal);
        INSTANCE.registerMessage(id++, Mappings.All.class, IMessage::writeToBuffer, IMessage.decode(Mappings.All::new), IMessage::onReceiveInternal);
        INSTANCE.registerMessage(id++, Mappings.Copy.class, IMessage::writeToBuffer, IMessage.decode(Mappings.Copy::new), IMessage::onReceiveInternal);
        INSTANCE.registerMessage(id++, Mappings.Update.class, IMessage::writeToBuffer, IMessage.decode(Mappings.Update::new), IMessage::onReceiveInternal);
        assert (id > 0);
    }

    public static void sendToClient(IMessage<?> message, World world) {
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> world.func_201675_m().func_186058_p()), message);
    }

    public static void sendToAround(IMessage<?> message, World world, BlockPos pos) {
        INSTANCE.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)256.0, (DimensionType)world.func_201675_m().func_186058_p())), message);
    }

    public static void sendToServer(IMessage<?> message) {
        INSTANCE.sendToServer(message);
    }
}

