/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.marker;

import com.yogpc.qp.machines.marker.TileMarker;
import com.yogpc.qp.packet.IMessage;
import java.util.Optional;
import java.util.function.Supplier;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateBoxMessage
implements IMessage<UpdateBoxMessage> {
    private BlockPos pos;
    private int dim;
    private boolean on;

    public static UpdateBoxMessage create(TileMarker marker, boolean on) {
        UpdateBoxMessage message = new UpdateBoxMessage();
        message.dim = IMessage.getDimId(marker.func_145831_w());
        message.pos = marker.func_174877_v();
        message.on = on;
        return message;
    }

    @Override
    public UpdateBoxMessage readFromBuffer(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.dim = buffer.readInt();
        this.on = buffer.readBoolean();
        return this;
    }

    @Override
    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).writeInt(this.dim);
        buffer.writeBoolean(this.on);
    }

    @Override
    public void onReceive(Supplier<NetworkEvent.Context> ctx) {
        Optional optionalWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(ctx.get().getDirection().getReceptionSide());
        optionalWorld.filter(world -> world.func_201675_m().func_186058_p().func_186068_a() == this.dim).filter(world -> world.func_175667_e(this.pos)).map(world -> world.func_175625_s(this.pos)).flatMap(MapStreamSyntax.optCast(TileMarker.class)).ifPresent(marker -> marker.laser.boxUpdate(marker.func_145831_w(), this.on));
    }
}

