/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.pump;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.pump.TilePump;
import com.yogpc.qp.packet.IMessage;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.function.Supplier;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class Mappings {

    public static enum Type {
        None(0),
        Remove(1),
        Add(2),
        Up(3),
        Top(4),
        Down(5),
        Bottom(6);

        public final int id;

        private Type(int i) {
            this.id = i;
        }

        public int getId() {
            return this.id;
        }

        public static Type fromID(int id) {
            switch (id) {
                case 1: {
                    return Remove;
                }
                case 2: {
                    return Add;
                }
                case 3: {
                    return Up;
                }
                case 4: {
                    return Top;
                }
                case 5: {
                    return Down;
                }
                case 6: {
                    return Bottom;
                }
            }
            return None;
        }
    }

    public static class Copy
    implements IMessage<Copy> {
        BlockPos pos;
        int dim;
        EnumFacing dest;
        LinkedList<String> list;

        public static Copy create(TilePump pump, EnumFacing dest, LinkedList<String> list) {
            Copy copy = new Copy();
            copy.dest = dest;
            copy.pos = pump.func_174877_v();
            copy.list = list;
            copy.dim = IMessage.getDimId(pump.func_145831_w());
            return copy;
        }

        @Override
        public Copy readFromBuffer(PacketBuffer buffer) {
            this.pos = buffer.func_179259_c();
            this.dest = (EnumFacing)buffer.func_179257_a(EnumFacing.class);
            this.dim = buffer.readInt();
            int length = buffer.readInt();
            this.list = new LinkedList();
            for (int i = 0; i < length; ++i) {
                this.list.add(buffer.func_150789_c(Short.MAX_VALUE));
            }
            return this;
        }

        @Override
        public void writeToBuffer(PacketBuffer buffer) {
            buffer.func_179255_a(this.pos).func_179249_a((Enum)this.dest).writeInt(this.dim).writeInt(this.list.size());
            this.list.forEach(arg_0 -> ((PacketBuffer)buffer).func_180714_a(arg_0));
        }

        @Override
        public void onReceive(Supplier<NetworkEvent.Context> ctx) {
            QuarryPlus.proxy.getPacketWorld(ctx.get()).filter(world -> world.func_201675_m().func_186058_p().func_186068_a() == this.dim).filter(world -> world.func_175667_e(this.pos)).map(world -> world.func_175625_s(this.pos)).flatMap(MapStreamSyntax.optCast(TilePump.class)).ifPresent(pump -> ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> pump.mapping.put(this.dest, this.list)));
        }
    }

    public static class Update
    implements IMessage<Update> {
        Type type;
        EnumFacing facing;
        BlockPos pos;
        int dim;
        String fluidName;

        public static Update create(TilePump pump, EnumFacing facing, Type type, String fluidName) {
            Update update = new Update();
            update.facing = facing;
            update.pos = pump.func_174877_v();
            update.type = type;
            update.fluidName = fluidName;
            update.dim = IMessage.getDimId(pump.func_145831_w());
            return update;
        }

        @Override
        public Update readFromBuffer(PacketBuffer buffer) {
            this.pos = buffer.func_179259_c();
            this.facing = (EnumFacing)buffer.func_179257_a(EnumFacing.class);
            this.type = (Type)buffer.func_179257_a(Type.class);
            this.fluidName = buffer.func_150789_c(Short.MAX_VALUE);
            this.dim = buffer.readInt();
            return this;
        }

        @Override
        public void writeToBuffer(PacketBuffer buffer) {
            buffer.func_179255_a(this.pos).func_179249_a((Enum)this.facing).func_179249_a((Enum)this.type).func_180714_a(this.fluidName).writeInt(this.dim);
        }

        @Override
        public void onReceive(Supplier<NetworkEvent.Context> ctx) {
            QuarryPlus.proxy.getPacketWorld(ctx.get()).filter(world -> world.func_201675_m().func_186058_p().func_186068_a() == this.dim).filter(world -> world.func_175667_e(this.pos)).map(world -> world.func_175625_s(this.pos)).flatMap(MapStreamSyntax.optCast(TilePump.class)).ifPresent(pump -> ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> {
                LinkedList<String> list = pump.mapping.get(this.facing);
                Update.typeAction(list, this.fluidName, this.type);
            }));
        }

        public static void typeAction(LinkedList<String> list, String fluidName, Type type) {
            int i = list.indexOf(fluidName);
            switch (type) {
                case Add: {
                    list.add(fluidName);
                    break;
                }
                case Remove: {
                    list.remove(fluidName);
                    break;
                }
                case Up: {
                    if (i <= 0) break;
                    list.remove(i);
                    list.add(i - 1, fluidName);
                    break;
                }
                case Top: {
                    if (i <= 0) break;
                    list.remove(i);
                    list.addFirst(fluidName);
                    break;
                }
                case Down: {
                    if (i < 0 || i == list.size() - 1) break;
                    list.remove(i);
                    list.add(i + 1, fluidName);
                    break;
                }
                case Bottom: {
                    if (i < 0 || i == list.size() - 1) break;
                    list.remove(i);
                    list.addLast(fluidName);
                    break;
                }
            }
        }
    }

    public static class All
    implements IMessage<All> {
        BlockPos pos;
        int dim;
        EnumFacing facing;
        EnumMap<EnumFacing, LinkedList<String>> map = new EnumMap(EnumFacing.class);

        public static All create(TilePump pump, EnumFacing facing) {
            All message = new All();
            message.pos = pump.func_174877_v();
            message.dim = IMessage.getDimId(pump.func_145831_w());
            message.facing = facing;
            message.map = new EnumMap<EnumFacing, LinkedList<String>>(pump.mapping);
            return message;
        }

        @Override
        public All readFromBuffer(PacketBuffer buffer) {
            this.pos = buffer.func_179259_c();
            this.dim = buffer.readInt();
            this.facing = (EnumFacing)buffer.func_179257_a(EnumFacing.class);
            for (EnumFacing VALUE : EnumFacing.values()) {
                int l = buffer.readInt();
                LinkedList<String> strings = new LinkedList<String>();
                for (int j = 0; j < l; ++j) {
                    strings.add(buffer.func_150789_c(Short.MAX_VALUE));
                }
                this.map.put(VALUE, strings);
            }
            return this;
        }

        @Override
        public void writeToBuffer(PacketBuffer buffer) {
            buffer.func_179255_a(this.pos).writeInt(this.dim);
            buffer.func_179249_a((Enum)this.facing);
            for (LinkedList<String> strings : this.map.values()) {
                buffer.writeInt(strings.size());
                strings.forEach(arg_0 -> ((PacketBuffer)buffer).func_180714_a(arg_0));
            }
        }

        @Override
        public void onReceive(Supplier<NetworkEvent.Context> ctx) {
            QuarryPlus.proxy.getPacketWorld(ctx.get()).filter(world -> world.func_201675_m().func_186058_p().func_186068_a() == this.dim).filter(world -> world.func_175667_e(this.pos)).map(world -> world.func_175625_s(this.pos)).flatMap(MapStreamSyntax.optCast(TilePump.class)).ifPresent(pump -> {
                pump.mapping.clear();
                pump.mapping.putAll(this.map);
            });
        }
    }
}

