/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.quarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.packet.IMessage;
import java.util.function.Supplier;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class ModeMessage
implements IMessage<ModeMessage> {
    int dim;
    BlockPos pos;
    BlockPos minPos;
    BlockPos maxPos;
    TileQuarry.Mode mode;

    public static ModeMessage create(TileQuarry quarry) {
        ModeMessage message = new ModeMessage();
        message.dim = IMessage.getDimId(quarry.func_145831_w());
        message.pos = quarry.func_174877_v();
        message.mode = quarry.G_getNow();
        message.minPos = quarry.getMinPos();
        message.maxPos = quarry.getMaxPos();
        return message;
    }

    @Override
    public ModeMessage readFromBuffer(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.minPos = buffer.func_179259_c();
        this.maxPos = buffer.func_179259_c();
        this.mode = (TileQuarry.Mode)buffer.func_179257_a(TileQuarry.Mode.class);
        this.dim = buffer.readInt();
        return this;
    }

    @Override
    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).func_179255_a(this.minPos).func_179255_a(this.maxPos).func_179249_a((Enum)this.mode).writeInt(this.dim);
    }

    @Override
    public void onReceive(Supplier<NetworkEvent.Context> ctx) {
        QuarryPlus.proxy.getPacketWorld(ctx.get()).filter(world -> world.func_201675_m().func_186058_p().func_186068_a() == this.dim).filter(world -> world.func_175667_e(this.pos)).map(world -> world.func_175625_s(this.pos)).flatMap(MapStreamSyntax.optCast(TileQuarry.class)).ifPresent(quarry -> ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> {
            quarry.setNow(this.mode);
            quarry.xMin = this.minPos.func_177958_n();
            quarry.yMin = this.minPos.func_177956_o();
            quarry.zMin = this.minPos.func_177952_p();
            quarry.xMax = this.maxPos.func_177958_n();
            quarry.yMax = this.maxPos.func_177956_o();
            quarry.zMax = this.maxPos.func_177952_p();
        }));
    }
}

