/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import com.yogpc.qp.Config;
import com.yogpc.qp.machines.GuiHandler;
import com.yogpc.qp.machines.marker.TileMarker;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.render.DummyBlockBakedModel;
import com.yogpc.qp.render.RenderMarker;
import com.yogpc.qp.render.RenderQuarry;
import com.yogpc.qp.render.Sprites;
import com.yogpc.qp.utils.Holder;
import com.yogpc.qp.utils.ProxyCommon;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;

@OnlyIn(value=Dist.CLIENT)
public class ProxyClient
extends ProxyCommon {
    private DummyBlockBakedModel dummyBlockBakedModel;
    private DummyBlockBakedModel dummyItemBakedModel;

    @Override
    public Optional<EntityPlayer> getPacketPlayer(NetworkEvent.Context context) {
        if (context.getSender() != null) {
            return Optional.of(context.getSender());
        }
        return Optional.ofNullable(Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    public Optional<World> getPacketWorld(NetworkEvent.Context context) {
        EntityPlayerMP sender = context.getSender();
        if (sender == null) {
            return Optional.of(this.getClientWorld());
        }
        return Optional.of(sender).map(Entity::func_130014_f_);
    }

    @Override
    public void registerEvents(IEventBus bus) {
        super.registerEvents(bus);
        bus.addListener(Sprites::putTexture);
        bus.addListener(Sprites::registerTexture);
        bus.addListener(this::onBake);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.GUIFACTORY, () -> GuiHandler::getGui);
    }

    @Override
    public void removeEntity(Entity e) {
        e.field_70170_p.func_72900_e(e);
        if (e.field_70170_p.field_72995_K) {
            ((WorldClient)e.field_70170_p).func_73028_b(e.func_145782_y());
        }
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public void registerTextures(FMLCommonSetupEvent event) {
        if (((Boolean)Config.client().enableRender().get()).booleanValue()) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileMarker.class, (TileEntityRenderer)RenderMarker.instance());
            ClientRegistry.bindTileEntitySpecialRenderer(TileQuarry.class, (TileEntityRenderer)RenderQuarry.instance());
        }
    }

    public void onBake(ModelBakeEvent event) {
        String itemTexName = "minecraft:glass";
        IBakedModel blockModel = this.getModel(event.getModelManager(), new ModelResourceLocation(itemTexName));
        IBakedModel itemModel = this.getModel(event.getModelManager(), new ModelResourceLocation(itemTexName, "inventory"));
        this.dummyBlockBakedModel = new DummyBlockBakedModel(blockModel);
        this.dummyItemBakedModel = new DummyBlockBakedModel(itemModel);
        ResourceLocation pathIn = Objects.requireNonNull(Holder.blockDummy().getRegistryName());
        event.getModelRegistry().put(new ModelResourceLocation(pathIn.toString()), this.dummyBlockBakedModel);
        event.getModelRegistry().put(new ModelResourceLocation(pathIn, "inventory"), this.dummyItemBakedModel);
    }

    @Override
    public void setDummyTexture(String textureName) {
        String itemTexName = textureName.split("#")[0];
        ModelManager manager = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a();
        this.dummyBlockBakedModel.model = this.getModel(manager, new ModelResourceLocation(textureName));
        this.dummyItemBakedModel.model = this.getModel(manager, new ModelResourceLocation(itemTexName, "inventory"));
    }

    private IBakedModel getModel(ModelManager manager, ModelResourceLocation location) {
        return manager.func_174953_a(new ModelResourceLocation("minecraft:glass", location.func_177518_c()));
    }
}

