/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.util;

import appeng.api.util.WorldCoord;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.Dimension;

public class DimensionalCoord
extends WorldCoord {
    private final IWorld world;
    private final Dimension dimension;

    public DimensionalCoord(DimensionalCoord coordinate) {
        super(coordinate.x, coordinate.y, coordinate.z);
        this.world = coordinate.world;
        this.dimension = coordinate.dimension;
    }

    public DimensionalCoord(TileEntity tileEntity) {
        super(tileEntity);
        this.world = tileEntity.func_145831_w();
        this.dimension = this.world.func_201675_m();
    }

    public DimensionalCoord(IWorld world, int x, int y, int z) {
        super(x, y, z);
        this.world = world;
        this.dimension = world.func_201675_m();
    }

    public DimensionalCoord(IWorld world, BlockPos pos) {
        super(pos);
        this.world = world;
        this.dimension = world.func_201675_m();
    }

    @Override
    public DimensionalCoord copy() {
        return new DimensionalCoord(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.dimension.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DimensionalCoord && this.isEqual((DimensionalCoord)obj);
    }

    @Override
    public String toString() {
        return "dimension=" + this.dimension + ", " + super.toString();
    }

    public boolean isInWorld(IWorld world) {
        return this.world == world;
    }

    public IWorld getWorld() {
        return this.world;
    }

    private boolean isEqual(DimensionalCoord c) {
        return this.x == c.x && this.y == c.y && this.z == c.z && c.world == this.world;
    }
}

