/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.grindstone;

import appeng.api.implementations.tiles.ICrankable;
import appeng.block.AEBaseTileBlock;
import appeng.core.stats.AeStats;
import appeng.tile.AEBaseTileEntity;
import appeng.tile.grindstone.CrankTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class CrankBlock
extends AEBaseTileBlock<CrankTileEntity> {
    public CrankBlock(Block.Properties props) {
        super(props);
    }

    @Override
    public ActionResultType onActivated(World w, BlockPos pos, PlayerEntity player, Hand hand, @Nullable ItemStack heldItem, BlockRayTraceResult hit) {
        if (player instanceof FakePlayer || player == null) {
            this.dropCrank(w, pos);
            return ActionResultType.SUCCESS;
        }
        CrankTileEntity tile = (CrankTileEntity)this.getTileEntity((IBlockReader)w, pos);
        if (tile != null) {
            if (tile.power()) {
                AeStats.TurnedCranks.addToPlayer(player, 1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private void dropCrank(World world, BlockPos pos) {
        world.func_175655_b(pos, true);
        world.func_184138_a(pos, this.func_176223_P(), world.func_180495_p(pos), 3);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Object tile = this.getTileEntity((IBlockReader)world, pos);
        if (tile != null) {
            Direction mnt = this.findCrankable((IBlockReader)world, pos);
            Direction forward = Direction.UP;
            if (mnt == Direction.UP || mnt == Direction.DOWN) {
                forward = Direction.SOUTH;
            }
            ((AEBaseTileEntity)tile).setOrientation(forward, mnt.func_176734_d());
        } else {
            this.dropCrank(world, pos);
        }
    }

    @Override
    public boolean isValidOrientation(IWorld w, BlockPos pos, Direction forward, Direction up) {
        TileEntity te = w.func_175625_s(pos);
        return !(te instanceof CrankTileEntity) || this.isCrankable((IBlockReader)w, pos, up.func_176734_d());
    }

    private Direction findCrankable(IBlockReader world, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            if (!this.isCrankable(world, pos, dir)) continue;
            return dir;
        }
        return null;
    }

    private boolean isCrankable(IBlockReader world, BlockPos pos, Direction offset) {
        BlockPos o = pos.func_177972_a(offset);
        TileEntity te = world.func_175625_s(o);
        return te instanceof ICrankable && ((ICrankable)te).canCrankAttach(offset.func_176734_d());
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Object tile = this.getTileEntity((IBlockReader)world, pos);
        if (tile != null) {
            if (!this.isCrankable((IBlockReader)world, pos, ((AEBaseTileEntity)tile).getUp().func_176734_d())) {
                this.dropCrank(world, pos);
            }
        } else {
            this.dropCrank(world, pos);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader w, BlockPos pos) {
        return this.findCrankable((IBlockReader)w, pos) != null;
    }

    private Direction getUp(IBlockReader world, BlockPos pos) {
        CrankTileEntity crank = (CrankTileEntity)this.getTileEntity(world, pos);
        return crank != null ? crank.getUp() : null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Direction up = this.getUp(world, pos);
        if (up == null) {
            return VoxelShapes.func_197880_a();
        }
        double xOff = -0.15 * (double)up.func_82601_c();
        double yOff = -0.15 * (double)up.func_96559_d();
        double zOff = -0.15 * (double)up.func_82599_e();
        return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(xOff + 0.15, yOff + 0.15, zOff + 0.15, xOff + 0.85, yOff + 0.85, zOff + 0.85));
    }
}

