/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseTileBlock;
import appeng.client.render.effects.ParticleTypes;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.tile.misc.QuartzGrowthAcceleratorTileEntity;
import appeng.util.Platform;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class QuartzGrowthAcceleratorBlock
extends AEBaseTileBlock<QuartzGrowthAcceleratorTileEntity>
implements IOrientableBlock {
    private static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");

    public QuartzGrowthAcceleratorBlock() {
        super(QuartzGrowthAcceleratorBlock.defaultProps(Material.field_151576_e).func_200947_a(SoundType.field_185852_e));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected BlockState updateBlockStateFromTileEntity(BlockState currentState, QuartzGrowthAcceleratorTileEntity te) {
        return (BlockState)currentState.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(te.isPowered()));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{POWERED});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World w, BlockPos pos, Random r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        QuartzGrowthAcceleratorTileEntity cga = (QuartzGrowthAcceleratorTileEntity)this.getTileEntity((IBlockReader)w, pos);
        if (cga != null && cga.isPowered() && AppEng.proxy.shouldAddParticles(r)) {
            double d0 = r.nextFloat() - 0.5f;
            double d1 = r.nextFloat() - 0.5f;
            Direction up = cga.getUp();
            Direction forward = cga.getForward();
            Direction west = Platform.crossProduct(forward, up);
            double rx = 0.5 + (double)pos.func_177958_n();
            double ry = 0.5 + (double)pos.func_177956_o();
            double rz = 0.5 + (double)pos.func_177952_p();
            rx += (double)up.func_82601_c() * d0;
            ry += (double)up.func_96559_d() * d0;
            rz += (double)up.func_82599_e() * d0;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            double dz = 0.0;
            double dx = 0.0;
            BlockPos pt = null;
            switch (r.nextInt(4)) {
                case 0: {
                    dx = 0.6;
                    dz = d1;
                    pt = new BlockPos(x + west.func_82601_c(), y + west.func_96559_d(), z + west.func_82599_e());
                    break;
                }
                case 1: {
                    dx = d1;
                    dz += 0.6;
                    pt = new BlockPos(x + forward.func_82601_c(), y + forward.func_96559_d(), z + forward.func_82599_e());
                    break;
                }
                case 2: {
                    dx = d1;
                    dz = -0.6;
                    pt = new BlockPos(x - forward.func_82601_c(), y - forward.func_96559_d(), z - forward.func_82599_e());
                    break;
                }
                case 3: {
                    dx = -0.6;
                    dz = d1;
                    pt = new BlockPos(x - west.func_82601_c(), y - west.func_96559_d(), z - west.func_82599_e());
                }
            }
            if (!w.func_180495_p(pt).func_177230_c().isAir(w.func_180495_p(pt), (IBlockReader)w, pt)) {
                return;
            }
            rx += dx * (double)west.func_82601_c();
            ry += dx * (double)west.func_96559_d();
            rz += dx * (double)west.func_82599_e();
            Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)ParticleTypes.LIGHTNING, rx += dz * (double)forward.func_82601_c(), ry += dz * (double)forward.func_96559_d(), rz += dz * (double)forward.func_82599_e(), 0.0, 0.0, 0.0);
        }
    }
}

