/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.block.AEBaseTileBlock;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.SecurityStationContainer;
import appeng.tile.misc.SecurityStationTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SecurityStationBlock
extends AEBaseTileBlock<SecurityStationTileEntity> {
    private static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");

    public SecurityStationBlock() {
        super(SecurityStationBlock.defaultProps(Material.field_151573_f));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{POWERED});
    }

    @Override
    protected BlockState updateBlockStateFromTileEntity(BlockState currentState, SecurityStationTileEntity te) {
        return (BlockState)currentState.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(te.isActive()));
    }

    @Override
    public ActionResultType onActivated(World w, BlockPos pos, PlayerEntity p, Hand hand, @Nullable ItemStack heldItem, BlockRayTraceResult hit) {
        if (p.func_213453_ef()) {
            return ActionResultType.PASS;
        }
        SecurityStationTileEntity tg = (SecurityStationTileEntity)this.getTileEntity((IBlockReader)w, pos);
        if (tg != null) {
            if (w.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            ContainerOpener.openContainer(SecurityStationContainer.TYPE, p, ContainerLocator.forTileEntitySide(tg, hit.func_216354_b()));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

