/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.block.AEBaseTileBlock;
import appeng.tile.misc.SkyCompassTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class SkyCompassBlock
extends AEBaseTileBlock<SkyCompassTileEntity> {
    public SkyCompassBlock(Block.Properties props) {
        super(props);
    }

    @Override
    public boolean isValidOrientation(IWorld w, BlockPos pos, Direction forward, Direction up) {
        SkyCompassTileEntity sc = (SkyCompassTileEntity)this.getTileEntity((IBlockReader)w, pos);
        if (sc != null) {
            return false;
        }
        return this.canPlaceAt((IBlockReader)w, pos, forward.func_176734_d());
    }

    private boolean canPlaceAt(IBlockReader w, BlockPos pos, Direction dir) {
        BlockPos test = pos.func_177972_a(dir);
        BlockState blockstate = w.func_180495_p(test);
        return blockstate.func_224755_d(w, test, dir.func_176734_d());
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        SkyCompassTileEntity sc = (SkyCompassTileEntity)this.getTileEntity((IBlockReader)world, pos);
        Direction forward = sc.getForward();
        if (!this.canPlaceAt((IBlockReader)world, pos, forward.func_176734_d())) {
            this.dropTorch(world, pos);
        }
    }

    private void dropTorch(World w, BlockPos pos) {
        BlockState prev = w.func_180495_p(pos);
        w.func_175655_b(pos, true);
        w.func_184138_a(pos, prev, w.func_180495_p(pos), 3);
    }

    public boolean func_196260_a(BlockState state, IWorldReader w, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            if (!this.canPlaceAt((IBlockReader)w, pos, dir)) continue;
            return true;
        }
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader w, BlockPos pos, ISelectionContext context) {
        SkyCompassTileEntity tile = (SkyCompassTileEntity)this.getTileEntity(w, pos);
        if (tile != null) {
            Direction forward = tile.getForward();
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 1.0;
            double maxY = 1.0;
            double maxZ = 1.0;
            switch (forward) {
                case DOWN: {
                    minX = 0.3125;
                    minZ = 0.3125;
                    maxX = 0.6875;
                    maxZ = 0.6875;
                    maxY = 1.0;
                    minY = 0.875;
                    break;
                }
                case EAST: {
                    minY = 0.3125;
                    minZ = 0.3125;
                    maxY = 0.6875;
                    maxZ = 0.6875;
                    maxX = 0.125;
                    minX = 0.0;
                    break;
                }
                case NORTH: {
                    minX = 0.3125;
                    minY = 0.3125;
                    maxX = 0.6875;
                    maxY = 0.6875;
                    maxZ = 1.0;
                    minZ = 0.875;
                    break;
                }
                case SOUTH: {
                    minX = 0.3125;
                    minY = 0.3125;
                    maxX = 0.6875;
                    maxY = 0.6875;
                    maxZ = 0.125;
                    minZ = 0.0;
                    break;
                }
                case UP: {
                    minX = 0.3125;
                    minZ = 0.3125;
                    maxX = 0.6875;
                    maxZ = 0.6875;
                    maxY = 0.125;
                    minY = 0.0;
                    break;
                }
                case WEST: {
                    minY = 0.3125;
                    minZ = 0.3125;
                    maxY = 0.6875;
                    maxZ = 0.6875;
                    maxX = 1.0;
                    minX = 0.875;
                    break;
                }
            }
            return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        }
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

