/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.paint;

import appeng.block.paint.PaintSplotches;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.helpers.Splotch;
import appeng.tile.misc.PaintSplotchesTileEntity;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

class PaintSplotchesBakedModel
implements IDynamicBakedModel {
    private static final Material TEXTURE_PAINT1 = new Material(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2", "block/paint1"));
    private static final Material TEXTURE_PAINT2 = new Material(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2", "block/paint2"));
    private static final Material TEXTURE_PAINT3 = new Material(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2", "block/paint3"));
    private final TextureAtlasSprite[] textures;

    PaintSplotchesBakedModel(Function<Material, TextureAtlasSprite> bakedTextureGetter) {
        this.textures = new TextureAtlasSprite[]{bakedTextureGetter.apply(TEXTURE_PAINT1), bakedTextureGetter.apply(TEXTURE_PAINT2), bakedTextureGetter.apply(TEXTURE_PAINT3)};
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side != null) {
            return Collections.emptyList();
        }
        PaintSplotches splotchesState = (PaintSplotches)extraData.getData(PaintSplotchesTileEntity.SPLOTCHES);
        if (splotchesState == null) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(1);
            CubeBuilder builder = new CubeBuilder(quads);
            builder.setTexture(this.textures[0]);
            builder.addCube(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f);
            return quads;
        }
        List<Splotch> splotches = splotchesState.getSplotches();
        CubeBuilder builder = new CubeBuilder();
        float offsetConstant = 0.001f;
        for (Splotch s : splotches) {
            if (s.isLumen()) {
                builder.setColorRGB(s.getColor().whiteVariant);
                builder.setRenderFullBright(true);
            } else {
                builder.setColorRGB(s.getColor().mediumVariant);
                builder.setRenderFullBright(false);
            }
            float offset = offsetConstant;
            offsetConstant += 0.001f;
            float buffer = 0.1f;
            float pos_x = s.x();
            float pos_y = s.y();
            pos_x = Math.max(0.1f, Math.min(0.9f, pos_x));
            pos_y = Math.max(0.1f, Math.min(0.9f, pos_y));
            TextureAtlasSprite ico = this.textures[s.getSeed() % this.textures.length];
            builder.setTexture(ico);
            builder.setCustomUv(s.getSide().func_176734_d(), 0.0f, 0.0f, 16.0f, 16.0f);
            switch (s.getSide()) {
                case UP: {
                    offset = 1.0f - offset;
                    builder.addQuad(Direction.DOWN, pos_x - 0.1f, offset, pos_y - 0.1f, pos_x + 0.1f, offset, pos_y + 0.1f);
                    break;
                }
                case DOWN: {
                    builder.addQuad(Direction.UP, pos_x - 0.1f, offset, pos_y - 0.1f, pos_x + 0.1f, offset, pos_y + 0.1f);
                    break;
                }
                case EAST: {
                    offset = 1.0f - offset;
                    builder.addQuad(Direction.WEST, offset, pos_x - 0.1f, pos_y - 0.1f, offset, pos_x + 0.1f, pos_y + 0.1f);
                    break;
                }
                case WEST: {
                    builder.addQuad(Direction.EAST, offset, pos_x - 0.1f, pos_y - 0.1f, offset, pos_x + 0.1f, pos_y + 0.1f);
                    break;
                }
                case SOUTH: {
                    offset = 1.0f - offset;
                    builder.addQuad(Direction.NORTH, pos_x - 0.1f, pos_y - 0.1f, offset, pos_x + 0.1f, pos_y + 0.1f, offset);
                    break;
                }
                case NORTH: {
                    builder.addQuad(Direction.SOUTH, pos_x - 0.1f, pos_y - 0.1f, offset, pos_x + 0.1f, pos_y + 0.1f, offset);
                    break;
                }
            }
        }
        return builder.getOutput();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.textures[0];
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public boolean func_230044_c_() {
        return false;
    }

    static List<Material> getRequiredTextures() {
        return ImmutableList.of((Object)TEXTURE_PAINT1, (Object)TEXTURE_PAINT2, (Object)TEXTURE_PAINT3);
    }
}

