/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.block.AEBaseTileBlock;
import appeng.block.storage.DriveSlotState;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.ChestContainer;
import appeng.core.localization.PlayerMessages;
import appeng.tile.storage.ChestTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ChestBlock
extends AEBaseTileBlock<ChestTileEntity> {
    private static final EnumProperty<DriveSlotState> SLOT_STATE = EnumProperty.func_177709_a((String)"slot_state", DriveSlotState.class);

    public ChestBlock() {
        super(ChestBlock.defaultProps(Material.field_151573_f));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(SLOT_STATE, (Comparable)((Object)DriveSlotState.EMPTY)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{SLOT_STATE});
    }

    @Override
    protected BlockState updateBlockStateFromTileEntity(BlockState currentState, ChestTileEntity te) {
        DriveSlotState slotState = DriveSlotState.EMPTY;
        if (te.getCellCount() >= 1) {
            slotState = DriveSlotState.fromCellStatus(te.getCellStatus(0));
        }
        if (!te.isPowered() && slotState != DriveSlotState.EMPTY) {
            slotState = DriveSlotState.OFFLINE;
        }
        return (BlockState)currentState.func_206870_a(SLOT_STATE, (Comparable)((Object)slotState));
    }

    @Override
    public ActionResultType onActivated(World w, BlockPos pos, PlayerEntity p, Hand hand, @Nullable ItemStack heldItem, BlockRayTraceResult hit) {
        ChestTileEntity tg = (ChestTileEntity)this.getTileEntity((IBlockReader)w, pos);
        if (tg != null && !p.func_213453_ef()) {
            if (w.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            if (hit.func_216354_b() == tg.getUp()) {
                if (!tg.openGui(p)) {
                    p.func_145747_a(PlayerMessages.ChestCannotReadStorageCell.get());
                }
            } else {
                ContainerOpener.openContainer(ChestContainer.TYPE, p, ContainerLocator.forTileEntitySide(tg, hit.func_216354_b()));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

