/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.block.AEBaseTileBlock;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.SkyChestContainer;
import appeng.tile.storage.SkyChestTileEntity;
import appeng.util.Platform;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SkyChestBlock
extends AEBaseTileBlock<SkyChestTileEntity> {
    private static final double AABB_OFFSET_BOTTOM = 0.0;
    private static final double AABB_OFFSET_SIDES = 0.06;
    private static final double AABB_OFFSET_TOP = 0.125;
    public final SkyChestType type;

    public SkyChestBlock(SkyChestType type, Block.Properties props) {
        super(props);
        this.type = type;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @Override
    public ActionResultType onActivated(World w, BlockPos pos, PlayerEntity player, Hand hand, @Nullable ItemStack heldItem, BlockRayTraceResult hit) {
        if (Platform.isServer()) {
            SkyChestTileEntity tile = (SkyChestTileEntity)this.getTileEntity((IBlockReader)w, pos);
            if (tile == null) {
                return ActionResultType.PASS;
            }
            ContainerOpener.openContainer(SkyChestContainer.TYPE, player, ContainerLocator.forTileEntity(tile));
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        AxisAlignedBB aabb = this.computeAABB(worldIn, pos);
        return VoxelShapes.func_197881_a((AxisAlignedBB)aabb);
    }

    private AxisAlignedBB computeAABB(IBlockReader w, BlockPos pos) {
        SkyChestTileEntity sk = (SkyChestTileEntity)this.getTileEntity(w, pos);
        Direction o = Direction.UP;
        if (sk != null) {
            o = sk.getUp();
        }
        double offsetX = o.func_82601_c() == 0 ? 0.06 : 0.0;
        double offsetY = o.func_96559_d() == 0 ? 0.06 : 0.0;
        double offsetZ = o.func_82599_e() == 0 ? 0.06 : 0.0;
        double minX = Math.max(0.0, offsetX + (o.func_82601_c() < 0 ? 0.0 : (double)o.func_82601_c() * 0.125));
        double minY = Math.max(0.0, offsetY + (o.func_96559_d() < 0 ? 0.125 : (double)o.func_96559_d() * 0.0));
        double minZ = Math.max(0.0, offsetZ + (o.func_82599_e() < 0 ? 0.0 : (double)o.func_82599_e() * 0.125));
        double maxX = Math.min(1.0, 1.0 - offsetX - (o.func_82601_c() < 0 ? 0.125 : (double)o.func_82601_c() * 0.0));
        double maxY = Math.min(1.0, 1.0 - offsetY - (o.func_96559_d() < 0 ? 0.0 : (double)o.func_96559_d() * 0.125));
        double maxZ = Math.min(1.0, 1.0 - offsetZ - (o.func_82599_e() < 0 ? 0.125 : (double)o.func_82599_e() * 0.0));
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static enum SkyChestType {
        STONE,
        BLOCK;

    }
}

