/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.api.definitions.IBlockDefinition;
import appeng.api.features.AEFeature;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseBlockItem;
import appeng.block.AEBaseTileBlock;
import appeng.bootstrap.BlockRendering;
import appeng.bootstrap.BlockRenderingCustomizer;
import appeng.bootstrap.FeatureFactory;
import appeng.bootstrap.IBlockBuilder;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.ItemRendering;
import appeng.bootstrap.definitions.TileEntityDefinition;
import appeng.core.AEItemGroup;
import appeng.core.CreativeTab;
import appeng.core.features.BlockDefinition;
import appeng.core.features.TileDefinition;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistryEntry;

class BlockDefinitionBuilder
implements IBlockBuilder {
    private final FeatureFactory factory;
    private final String registryName;
    private final Supplier<? extends Block> blockSupplier;
    private final List<BiFunction<Block, Item, IBootstrapComponent>> bootstrapComponents = new ArrayList<BiFunction<Block, Item, IBootstrapComponent>>();
    private final EnumSet<AEFeature> features = EnumSet.noneOf(AEFeature.class);
    private ItemGroup itemGroup = CreativeTab.INSTANCE;
    private TileEntityDefinition tileEntityDefinition;
    private boolean disableItem = false;
    private BiFunction<Block, Item.Properties, BlockItem> itemFactory;
    @OnlyIn(value=Dist.CLIENT)
    private BlockRendering blockRendering;
    @OnlyIn(value=Dist.CLIENT)
    private ItemRendering itemRendering;

    BlockDefinitionBuilder(FeatureFactory factory, String id, Supplier<? extends Block> blockSupplier) {
        this.factory = factory;
        this.registryName = id;
        this.blockSupplier = blockSupplier;
        if (Platform.hasClientClasses()) {
            this.blockRendering = new BlockRendering();
            this.itemRendering = new ItemRendering();
        }
    }

    @Override
    public BlockDefinitionBuilder bootstrap(BiFunction<Block, Item, IBootstrapComponent> callback) {
        this.bootstrapComponents.add(callback);
        return this;
    }

    @Override
    public IBlockBuilder features(AEFeature ... features) {
        this.features.clear();
        this.addFeatures(features);
        return this;
    }

    @Override
    public IBlockBuilder addFeatures(AEFeature ... features) {
        Collections.addAll(this.features, features);
        return this;
    }

    @Override
    public BlockDefinitionBuilder rendering(BlockRenderingCustomizer callback) {
        if (Platform.hasClientClasses()) {
            this.customizeForClient(callback);
        }
        return this;
    }

    @Override
    public IBlockBuilder tileEntity(TileEntityDefinition tileEntityDefinition) {
        this.tileEntityDefinition = tileEntityDefinition;
        return this;
    }

    @Override
    public IBlockBuilder item(BiFunction<Block, Item.Properties, BlockItem> factory) {
        this.itemFactory = factory;
        return this;
    }

    @Override
    public IBlockBuilder disableItem() {
        this.disableItem = true;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void customizeForClient(BlockRenderingCustomizer callback) {
        callback.customize(this.blockRendering, this.itemRendering);
    }

    @Override
    public <T extends IBlockDefinition> T build() {
        Block block = this.blockSupplier.get();
        block.setRegistryName("appliedenergistics2", this.registryName);
        BlockItem item = this.constructItemFromBlock(block);
        if (item != null) {
            item.setRegistryName("appliedenergistics2", this.registryName);
        }
        this.factory.addBootstrapComponent((side, registry) -> registry.register((IForgeRegistryEntry)block));
        if (item != null) {
            this.factory.addBootstrapComponent((side, registry) -> registry.register((IForgeRegistryEntry)item));
        }
        this.bootstrapComponents.forEach(component -> this.factory.addBootstrapComponent((IBootstrapComponent)component.apply(block, item)));
        if (this.tileEntityDefinition != null) {
            this.tileEntityDefinition.addBlock(block);
        }
        if (Platform.hasClientClasses()) {
            this.blockRendering.apply(this.factory, block);
            if (item != null) {
                this.itemRendering.apply(this.factory, (Item)item);
            }
        }
        BlockDefinition definition = block instanceof AEBaseTileBlock ? new TileDefinition(this.registryName, (AEBaseTileBlock)block, item, (Set<AEFeature>)this.features) : new BlockDefinition(this.registryName, block, item, this.features);
        if (this.itemGroup instanceof AEItemGroup) {
            ((AEItemGroup)this.itemGroup).add(definition);
        }
        return (T)definition;
    }

    @Nullable
    private BlockItem constructItemFromBlock(Block block) {
        if (this.disableItem) {
            return null;
        }
        Item.Properties itemProperties = new Item.Properties();
        if (this.itemGroup != null) {
            itemProperties.func_200916_a(this.itemGroup);
        }
        if (this.itemFactory != null) {
            return this.itemFactory.apply(block, itemProperties);
        }
        if (block instanceof AEBaseBlock) {
            return new AEBaseBlockItem(block, itemProperties);
        }
        return new BlockItem(block, itemProperties);
    }
}

