/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.api.features.AEFeature;
import appeng.bootstrap.FeatureFactory;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.IItemBuilder;
import appeng.bootstrap.ItemRendering;
import appeng.bootstrap.ItemRenderingCustomizer;
import appeng.core.AEItemGroup;
import appeng.core.CreativeTab;
import appeng.core.features.ItemDefinition;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistryEntry;

class ItemDefinitionBuilder
implements IItemBuilder {
    private final FeatureFactory factory;
    private final String registryName;
    private final Function<Item.Properties, Item> itemFactory;
    private final EnumSet<AEFeature> features = EnumSet.noneOf(AEFeature.class);
    private final List<Function<Item, IBootstrapComponent>> boostrapComponents = new ArrayList<Function<Item, IBootstrapComponent>>();
    private final Item.Properties props = new Item.Properties();
    private Supplier<IDispenseItemBehavior> dispenserBehaviorSupplier;
    @OnlyIn(value=Dist.CLIENT)
    private ItemRendering itemRendering;
    private ItemGroup itemGroup = CreativeTab.INSTANCE;

    ItemDefinitionBuilder(FeatureFactory factory, String registryName, Function<Item.Properties, Item> itemFactory) {
        this.factory = factory;
        this.registryName = registryName;
        this.itemFactory = itemFactory;
        if (Platform.hasClientClasses()) {
            this.itemRendering = new ItemRendering();
        }
    }

    @Override
    public IItemBuilder bootstrap(Function<Item, IBootstrapComponent> component) {
        this.boostrapComponents.add(component);
        return this;
    }

    @Override
    public IItemBuilder features(AEFeature ... features) {
        this.features.clear();
        this.addFeatures(features);
        return this;
    }

    @Override
    public IItemBuilder addFeatures(AEFeature ... features) {
        Collections.addAll(this.features, features);
        return this;
    }

    @Override
    public IItemBuilder itemGroup(ItemGroup itemGroup) {
        this.itemGroup = itemGroup;
        return this;
    }

    @Override
    public IItemBuilder props(Consumer<Item.Properties> consumer) {
        consumer.accept(this.props);
        return this;
    }

    @Override
    public IItemBuilder rendering(ItemRenderingCustomizer callback) {
        if (Platform.hasClientClasses()) {
            this.customizeForClient(callback);
        }
        return this;
    }

    @Override
    public IItemBuilder dispenserBehavior(Supplier<IDispenseItemBehavior> behavior) {
        this.dispenserBehaviorSupplier = behavior;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void customizeForClient(ItemRenderingCustomizer callback) {
        callback.customize(this.itemRendering);
    }

    @Override
    public ItemDefinition build() {
        this.props.func_200916_a(this.itemGroup);
        Item item = this.itemFactory.apply(this.props);
        item.setRegistryName("appliedenergistics2", this.registryName);
        ItemDefinition definition = new ItemDefinition(this.registryName, item, this.features);
        this.boostrapComponents.forEach(component -> this.factory.addBootstrapComponent((IBootstrapComponent)component.apply(item)));
        if (this.dispenserBehaviorSupplier != null) {
            this.factory.addBootstrapComponent(() -> {
                IDispenseItemBehavior behavior = this.dispenserBehaviorSupplier.get();
                DispenserBlock.func_199774_a((IItemProvider)item, (IDispenseItemBehavior)behavior);
            });
        }
        this.factory.addBootstrapComponent((side, reg) -> reg.register((IForgeRegistryEntry)item));
        if (Platform.hasClientClasses()) {
            this.itemRendering.apply(this.factory, item);
        }
        if (this.itemGroup instanceof AEItemGroup) {
            ((AEItemGroup)this.itemGroup).add(definition);
        }
        return definition;
    }
}

