/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.me.SlotME;
import appeng.container.AEBaseContainer;
import appeng.core.AEConfig;
import appeng.core.localization.ButtonToolTips;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class AEBaseMEScreen<T extends AEBaseContainer>
extends AEBaseScreen<T> {
    public AEBaseMEScreen(T container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
    }

    protected void renderTooltip(ItemStack stack, int x, int y) {
        Slot s = this.getSlot(x, y);
        if (s instanceof SlotME && !stack.func_190926_b()) {
            String local;
            int bigNumber = AEConfig.instance().isUseLargeFonts() ? 999 : 9999;
            IAEItemStack myStack = null;
            List currentToolTip = this.getTooltipFromItem(stack);
            try {
                SlotME theSlotField = (SlotME)s;
                myStack = theSlotField.getAEStack();
            }
            catch (Throwable theSlotField) {
                // empty catch block
            }
            if (myStack != null) {
                String format;
                String formattedAmount;
                if (myStack.getStackSize() > (long)bigNumber || myStack.getStackSize() > 1L && stack.func_77951_h()) {
                    local = ButtonToolTips.ItemsStored.getLocal();
                    formattedAmount = NumberFormat.getNumberInstance(Locale.US).format(myStack.getStackSize());
                    format = String.format(local, formattedAmount);
                    currentToolTip.add(TextFormatting.GRAY + format);
                }
                if (myStack.getCountRequestable() > 0L) {
                    local = ButtonToolTips.ItemsRequestable.getLocal();
                    formattedAmount = NumberFormat.getNumberInstance(Locale.US).format(myStack.getCountRequestable());
                    format = String.format(local, formattedAmount);
                    currentToolTip.add(format);
                }
                this.renderTooltip(currentToolTip, x, y, this.font);
                return;
            }
            if (stack.func_190916_E() > bigNumber) {
                local = ButtonToolTips.ItemsStored.getLocal();
                String formattedAmount = NumberFormat.getNumberInstance(Locale.US).format(stack.func_190916_E());
                String format = String.format(local, formattedAmount);
                currentToolTip.add(TextFormatting.GRAY + format);
                this.renderTooltip(currentToolTip, x, y, this.font);
                return;
            }
        }
        super.renderTooltip(stack, x, y);
    }
}

