/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.Size1Slot;
import appeng.client.gui.widgets.CustomSlotWidget;
import appeng.client.gui.widgets.ITooltip;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.me.InternalSlotME;
import appeng.client.me.SlotDisconnected;
import appeng.client.me.SlotME;
import appeng.client.render.StackSizeRenderer;
import appeng.container.AEBaseContainer;
import appeng.container.slot.AppEngCraftingSlot;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.CraftingTermSlot;
import appeng.container.slot.DisabledSlot;
import appeng.container.slot.FakeSlot;
import appeng.container.slot.IOptionalSlot;
import appeng.container.slot.InaccessibleSlot;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.PatternTermSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.core.sync.packets.SwapSlotsPacket;
import appeng.fluids.client.render.FluidStackSizeRenderer;
import appeng.fluids.container.slots.IMEFluidSlot;
import appeng.helpers.InventoryAction;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fml.client.gui.GuiUtils;

public abstract class AEBaseScreen<T extends AEBaseContainer>
extends ContainerScreen<T> {
    private final List<InternalSlotME> meSlots = new ArrayList<InternalSlotME>();
    private final Set<Slot> drag_click = new HashSet<Slot>();
    private final StackSizeRenderer stackSizeRenderer = new StackSizeRenderer();
    private final FluidStackSizeRenderer fluidStackSizeRenderer = new FluidStackSizeRenderer();
    private Scrollbar myScrollBar = null;
    private boolean disableShiftClick = false;
    private Stopwatch dbl_clickTimer = Stopwatch.createStarted();
    private ItemStack dbl_whichItem = ItemStack.field_190927_a;
    private Slot bl_clicked;
    protected final List<CustomSlotWidget> guiSlots = new ArrayList<CustomSlotWidget>();

    public AEBaseScreen(T container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
    }

    public void init() {
        super.init();
        List<Slot> slots = this.getInventorySlots();
        slots.removeIf(slot -> slot instanceof SlotME);
        for (InternalSlotME me : this.meSlots) {
            slots.add((Slot)new SlotME(me));
        }
    }

    private List<Slot> getInventorySlots() {
        return ((AEBaseContainer)this.field_147002_h).field_75151_b;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        RenderSystem.enableDepthTest();
        for (CustomSlotWidget c : this.guiSlots) {
            this.drawGuiSlot(c, mouseX, mouseY, partialTicks);
        }
        RenderSystem.disableDepthTest();
        for (CustomSlotWidget c : this.guiSlots) {
            this.drawTooltip(c, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        RenderSystem.popMatrix();
        RenderSystem.enableDepthTest();
        this.func_191948_b(mouseX, mouseY);
        for (CustomSlotWidget c : this.buttons) {
            if (!(c instanceof ITooltip)) continue;
            this.drawTooltip(c, mouseX, mouseY);
        }
    }

    protected void drawGuiSlot(CustomSlotWidget slot, int mouseX, int mouseY, float partialTicks) {
        if (slot.isSlotEnabled()) {
            int left = slot.xPos();
            int top = slot.yPos();
            int right = left + slot.getWidth();
            int bottom = top + slot.getHeight();
            slot.drawContent(this.getMinecraft(), mouseX, mouseY, partialTicks);
            if (this.func_195359_a(left, top, slot.getWidth(), slot.getHeight(), mouseX, mouseY) && slot.canClick((PlayerEntity)this.getPlayer())) {
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.fillGradient(left, top, right, bottom, -2130706433, -2130706433);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
        }
    }

    private void drawTooltip(ITooltip tooltip, int mouseX, int mouseY) {
        int x = tooltip.xPos();
        int y = tooltip.yPos();
        if (x < mouseX && x + tooltip.getWidth() > mouseX && tooltip.isVisible() && y < mouseY && y + tooltip.getHeight() > mouseY) {
            String msg;
            if (y < 15) {
                y = 15;
            }
            if ((msg = tooltip.getMessage()) != null) {
                this.drawTooltip(x + 11, y + 4, msg);
            }
        }
    }

    protected void drawTooltip(int x, int y, String message) {
        String[] lines = message.split("\n");
        this.drawTooltip(x, y, Arrays.asList(lines));
    }

    protected void drawTooltip(int x, int y, List<String> lines) {
        if (lines.isEmpty()) {
            return;
        }
        lines = Lists.newArrayList(lines);
        lines.set(0, TextFormatting.WHITE + (String)lines.get(0));
        for (int i = 1; i < lines.size(); ++i) {
            lines.set(i, TextFormatting.GRAY + (String)lines.get(i));
        }
        this.renderTooltip(lines, x, y, this.font);
    }

    protected final void func_146979_b(int x, int y) {
        int ox = this.field_147003_i;
        int oy = this.field_147009_r;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.getScrollBar() != null) {
            this.getScrollBar().draw(this);
        }
        this.drawFG(ox, oy, x, y);
    }

    public abstract void drawFG(int var1, int var2, int var3, int var4);

    protected final void func_146976_a(float f, int x, int y) {
        int ox = this.field_147003_i;
        int oy = this.field_147009_r;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBG(ox, oy, x, y, f);
        List<Slot> slots = this.getInventorySlots();
        for (Slot slot : slots) {
            IOptionalSlot optionalSlot;
            if (!(slot instanceof IOptionalSlot) || !(optionalSlot = (IOptionalSlot)slot).isRenderDisabled()) continue;
            AppEngSlot aeSlot = (AppEngSlot)slot;
            if (aeSlot.isSlotEnabled()) {
                GuiUtils.drawTexturedModalRect((int)(ox + aeSlot.field_75223_e - 1), (int)(oy + aeSlot.field_75221_f - 1), (int)(optionalSlot.getSourceX() - 1), (int)(optionalSlot.getSourceY() - 1), (int)18, (int)18, (float)this.getBlitOffset());
                continue;
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            RenderSystem.enableBlend();
            GuiUtils.drawTexturedModalRect((int)(ox + aeSlot.field_75223_e - 1), (int)(oy + aeSlot.field_75221_f - 1), (int)(optionalSlot.getSourceX() - 1), (int)(optionalSlot.getSourceY() - 1), (int)18, (int)18, (float)this.getBlitOffset());
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (CustomSlotWidget customSlotWidget : this.guiSlots) {
            customSlotWidget.drawBackground(ox, oy, this.getBlitOffset());
        }
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        this.drag_click.clear();
        if (btn == 1) {
            for (Object o : this.buttons) {
                Widget widget = (Widget)o;
                if (!widget.isMouseOver(xCoord, yCoord)) continue;
                return super.mouseClicked(xCoord, yCoord, 0);
            }
        }
        for (CustomSlotWidget slot : this.guiSlots) {
            if (!this.func_195359_a(slot.xPos(), slot.yPos(), slot.getWidth(), slot.getHeight(), xCoord, yCoord) || !slot.canClick((PlayerEntity)this.getPlayer())) continue;
            slot.slotClicked(this.getPlayer().field_71071_by.func_70445_o(), btn);
        }
        if (this.getScrollBar() != null) {
            this.getScrollBar().click(xCoord - (double)this.field_147003_i, yCoord - (double)this.field_147009_r);
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        Slot slot = this.getSlot((int)mouseX, (int)mouseY);
        ItemStack itemstack = this.getPlayer().field_71071_by.func_70445_o();
        if (this.getScrollBar() != null) {
            this.getScrollBar().click((int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r);
        }
        if (slot instanceof FakeSlot && !itemstack.func_190926_b()) {
            this.drag_click.add(slot);
            if (this.drag_click.size() > 1) {
                for (Slot dr : this.drag_click) {
                    InventoryActionPacket p = new InventoryActionPacket(mouseButton == 0 ? InventoryAction.PICKUP_OR_SET_DOWN : InventoryAction.PLACE_SINGLE, dr.field_75222_d, 0L);
                    NetworkHandler.instance().sendToServer(p);
                }
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    protected void func_184098_a(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        ClientPlayerEntity player = this.getPlayer();
        if (slot instanceof FakeSlot) {
            InventoryAction action;
            InventoryAction inventoryAction = action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
            if (this.drag_click.size() > 1) {
                return;
            }
            InventoryActionPacket p = new InventoryActionPacket(action, slotIdx, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot instanceof PatternTermSlot) {
            if (mouseButton == 6) {
                return;
            }
            NetworkHandler.instance().sendToServer(((PatternTermSlot)slot).getRequest(AEBaseScreen.hasShiftDown()));
        } else if (slot instanceof CraftingTermSlot) {
            if (mouseButton == 6) {
                return;
            }
            InventoryAction action = AEBaseScreen.hasShiftDown() ? InventoryAction.CRAFT_SHIFT : (mouseButton == 1 ? InventoryAction.CRAFT_STACK : InventoryAction.CRAFT_ITEM);
            InventoryActionPacket p = new InventoryActionPacket(action, slotIdx, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)32) && this.enableSpaceClicking()) {
            IAEItemStack stack = null;
            if (slot instanceof SlotME) {
                stack = ((SlotME)slot).getAEStack();
            }
            int slotNum = this.getInventorySlots().size();
            if (!(slot instanceof SlotME) && slot != null) {
                slotNum = slot.field_75222_d;
            }
            ((AEBaseContainer)this.field_147002_h).setTargetStack(stack);
            InventoryActionPacket p = new InventoryActionPacket(InventoryAction.MOVE_REGION, slotNum, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot instanceof SlotDisconnected) {
            InventoryAction action = null;
            switch (clickType) {
                case PICKUP: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case CLONE: {
                    if (!player.field_71075_bZ.field_75098_d) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                InventoryActionPacket p = new InventoryActionPacket(action, slot.getSlotIndex(), ((SlotDisconnected)slot).getSlot().getId());
                NetworkHandler.instance().sendToServer(p);
            }
            return;
        }
        if (slot instanceof SlotME) {
            InventoryAction action = null;
            IAEItemStack stack = null;
            switch (clickType) {
                case PICKUP: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    stack = ((SlotME)slot).getAEStack();
                    if (stack == null || action != InventoryAction.PICKUP_OR_SET_DOWN || stack.getStackSize() != 0L || !player.field_71071_by.func_70445_o().func_190926_b()) break;
                    action = InventoryAction.AUTO_CRAFT;
                    break;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    stack = ((SlotME)slot).getAEStack();
                    break;
                }
                case CLONE: {
                    IAEItemStack slotItem;
                    stack = ((SlotME)slot).getAEStack();
                    if (stack != null && stack.isCraftable()) {
                        action = InventoryAction.AUTO_CRAFT;
                        break;
                    }
                    if (!player.field_71075_bZ.field_75098_d || (slotItem = ((SlotME)slot).getAEStack()) == null) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                ((AEBaseContainer)this.field_147002_h).setTargetStack(stack);
                InventoryActionPacket p = new InventoryActionPacket(action, this.getInventorySlots().size(), 0L);
                NetworkHandler.instance().sendToServer(p);
            }
            return;
        }
        if (!this.disableShiftClick && AEBaseScreen.hasShiftDown() && mouseButton == 0) {
            this.disableShiftClick = true;
            if (this.dbl_whichItem.func_190926_b() || this.bl_clicked != slot || this.dbl_clickTimer.elapsed(TimeUnit.MILLISECONDS) > 250L) {
                this.bl_clicked = slot;
                this.dbl_clickTimer = Stopwatch.createStarted();
                this.dbl_whichItem = slot != null ? (slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : ItemStack.field_190927_a) : ItemStack.field_190927_a;
            } else if (!this.dbl_whichItem.func_190926_b()) {
                List<Slot> slots = this.getInventorySlots();
                for (Slot inventorySlot : slots) {
                    if (inventorySlot == null || !inventorySlot.func_82869_a((PlayerEntity)this.getPlayer()) || !inventorySlot.func_75216_d() || !inventorySlot.isSameInventory(slot) || !Container.func_94527_a((Slot)inventorySlot, (ItemStack)this.dbl_whichItem, (boolean)true)) continue;
                    this.func_184098_a(inventorySlot, inventorySlot.field_75222_d, 0, ClickType.QUICK_MOVE);
                }
                this.dbl_whichItem = ItemStack.field_190927_a;
            }
            this.disableShiftClick = false;
        }
        super.func_184098_a(slot, slotIdx, mouseButton, clickType);
    }

    protected boolean func_195363_d(int keyCode, int scanCode) {
        return this.checkHotbarKeys(InputMappings.func_197954_a((int)keyCode, (int)scanCode));
    }

    protected ClientPlayerEntity getPlayer() {
        return (ClientPlayerEntity)Preconditions.checkNotNull((Object)this.getMinecraft().field_71439_g);
    }

    protected boolean checkHotbarKeys(InputMappings.Input input) {
        Slot theSlot = this.getSlotUnderMouse();
        if (this.getPlayer().field_71071_by.func_70445_o().func_190926_b() && theSlot != null) {
            for (int j = 0; j < 9; ++j) {
                if (!this.getMinecraft().field_71474_y.field_151456_ac[j].isActiveAndMatches(input)) continue;
                List<Slot> slots = this.getInventorySlots();
                for (Slot s : slots) {
                    if (s.getSlotIndex() != j || s.field_75224_c != ((AEBaseContainer)this.field_147002_h).getPlayerInv() || s.func_82869_a(((AEBaseContainer)this.field_147002_h).getPlayerInv().field_70458_d)) continue;
                    return false;
                }
                if (theSlot.func_75219_a() == 64) {
                    this.func_184098_a(theSlot, theSlot.field_75222_d, j, ClickType.SWAP);
                    return true;
                }
                for (Slot s : slots) {
                    if (s.getSlotIndex() != j || s.field_75224_c != ((AEBaseContainer)this.field_147002_h).getPlayerInv()) continue;
                    NetworkHandler.instance().sendToServer(new SwapSlotsPacket(s.field_75222_d, theSlot.field_75222_d));
                    return true;
                }
            }
        }
        return false;
    }

    public void removed() {
        super.removed();
    }

    protected Slot getSlot(int mouseX, int mouseY) {
        List<Slot> slots = this.getInventorySlots();
        for (Slot slot : slots) {
            if (!this.func_195359_a(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }

    public abstract void drawBG(int var1, int var2, int var3, int var4, float var5);

    public boolean mouseScrolled(double x, double y, double wheelDelta) {
        if (wheelDelta != 0.0 && AEBaseScreen.hasShiftDown()) {
            this.mouseWheelEvent(x, y, wheelDelta / Math.abs(wheelDelta));
            return true;
        }
        if (wheelDelta != 0.0 && this.getScrollBar() != null) {
            this.getScrollBar().wheel(wheelDelta);
            return true;
        }
        return false;
    }

    private void mouseWheelEvent(double x, double y, double wheel) {
        IAEItemStack item;
        Slot slot = this.getSlot((int)x, (int)y);
        if (slot instanceof SlotME && (item = ((SlotME)slot).getAEStack()) != null) {
            ((AEBaseContainer)this.field_147002_h).setTargetStack(item);
            InventoryAction direction = wheel > 0.0 ? InventoryAction.ROLL_DOWN : InventoryAction.ROLL_UP;
            int times = (int)Math.abs(wheel);
            int inventorySize = this.getInventorySlots().size();
            for (int h = 0; h < times; ++h) {
                InventoryActionPacket p = new InventoryActionPacket(direction, inventorySize, 0L);
                NetworkHandler.instance().sendToServer(p);
            }
        }
    }

    protected boolean enableSpaceClicking() {
        return true;
    }

    public void bindTexture(String base, String file) {
        ResourceLocation loc = new ResourceLocation(base, "textures/" + file);
        this.getMinecraft().func_110434_K().func_110577_a(loc);
    }

    protected void drawItem(int x, int y, ItemStack is) {
        this.itemRenderer.field_77023_b = 100.0f;
        RenderHelper.func_227780_a_();
        this.itemRenderer.func_180450_b(is, x, y);
        RenderHelper.func_74518_a();
        this.itemRenderer.field_77023_b = 0.0f;
    }

    protected String getGuiDisplayName(String in) {
        return this.hasCustomInventoryName() ? this.getInventoryName() : in;
    }

    private boolean hasCustomInventoryName() {
        return ((AEBaseContainer)this.field_147002_h).getCustomName() != null;
    }

    private String getInventoryName() {
        return ((AEBaseContainer)this.field_147002_h).getCustomName();
    }

    public void func_146977_a(Slot s) {
        if (s instanceof SlotME) {
            try {
                if (!this.isPowered()) {
                    AEBaseScreen.fill((int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)0x66111111);
                }
                super.func_146977_a((Slot)new Size1Slot((SlotME)s));
                this.stackSizeRenderer.renderStackSize(this.font, ((SlotME)s).getAEStack(), s.field_75223_e, s.field_75221_f);
            }
            catch (Exception err) {
                AELog.warn("[AppEng] AE prevented crash while drawing slot: " + err.toString(), new Object[0]);
            }
            return;
        }
        if (s instanceof IMEFluidSlot && ((IMEFluidSlot)s).shouldRenderAsFluid()) {
            IMEFluidSlot slot = (IMEFluidSlot)s;
            IAEFluidStack fs = slot.getAEFluidStack();
            if (fs != null && this.isPowered()) {
                RenderSystem.disableBlend();
                Fluid fluid = fs.getFluid();
                FluidAttributes fluidAttributes = fluid.getAttributes();
                this.bindTexture(AtlasTexture.field_110575_b);
                ResourceLocation fluidStillTexture = fluidAttributes.getStillTexture(fs.getFluidStack());
                TextureAtlasSprite sprite = (TextureAtlasSprite)this.getMinecraft().func_228015_a_(AtlasTexture.field_110575_b).apply(fluidStillTexture);
                float red = (float)(fluidAttributes.getColor() >> 16 & 0xFF) / 255.0f;
                float green = (float)(fluidAttributes.getColor() >> 8 & 0xFF) / 255.0f;
                float blue = (float)(fluidAttributes.getColor() & 0xFF) / 255.0f;
                RenderSystem.color3f((float)red, (float)green, (float)blue);
                AEBaseScreen.blit((int)s.field_75223_e, (int)s.field_75221_f, (int)0, (int)16, (int)16, (TextureAtlasSprite)sprite);
                RenderSystem.enableBlend();
                this.fluidStackSizeRenderer.renderStackSize(this.font, fs, s.field_75223_e, s.field_75221_f);
            } else if (!this.isPowered()) {
                AEBaseScreen.fill((int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)0x66111111);
            }
            return;
        }
        try {
            AppEngSlot aes;
            ItemStack is = s.func_75211_c();
            if (s instanceof AppEngSlot && (((AppEngSlot)s).renderIconWithItem() || is.func_190926_b()) && ((AppEngSlot)s).shouldDisplay() && (aes = (AppEngSlot)s).getIcon() >= 0) {
                this.bindTexture("guis/states.png");
                try {
                    int uv_y = aes.getIcon() / 16;
                    int uv_x = aes.getIcon() - uv_y * 16;
                    RenderSystem.enableBlend();
                    RenderSystem.enableTexture();
                    RenderSystem.blendFunc((int)770, (int)771);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    float par1 = aes.field_75223_e;
                    float par2 = aes.field_75221_f;
                    float par3 = uv_x * 16;
                    float par4 = uv_y * 16;
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder vb = tessellator.func_178180_c();
                    vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    float f1 = 0.00390625f;
                    float f = 0.00390625f;
                    float par6 = 16.0f;
                    vb.func_225582_a_((double)(par1 + 0.0f), (double)(par2 + 16.0f), (double)this.getBlitOffset()).func_225583_a_((par3 + 0.0f) * 0.00390625f, (par4 + 16.0f) * 0.00390625f).func_227885_a_(1.0f, 1.0f, 1.0f, aes.getOpacityOfIcon()).func_181675_d();
                    float par5 = 16.0f;
                    vb.func_225582_a_((double)(par1 + 16.0f), (double)(par2 + 16.0f), (double)this.getBlitOffset()).func_225583_a_((par3 + 16.0f) * 0.00390625f, (par4 + 16.0f) * 0.00390625f).func_227885_a_(1.0f, 1.0f, 1.0f, aes.getOpacityOfIcon()).func_181675_d();
                    vb.func_225582_a_((double)(par1 + 16.0f), (double)(par2 + 0.0f), (double)this.getBlitOffset()).func_225583_a_((par3 + 16.0f) * 0.00390625f, (par4 + 0.0f) * 0.00390625f).func_227885_a_(1.0f, 1.0f, 1.0f, aes.getOpacityOfIcon()).func_181675_d();
                    vb.func_225582_a_((double)(par1 + 0.0f), (double)(par2 + 0.0f), (double)this.getBlitOffset()).func_225583_a_((par3 + 0.0f) * 0.00390625f, (par4 + 0.0f) * 0.00390625f).func_227885_a_(1.0f, 1.0f, 1.0f, aes.getOpacityOfIcon()).func_181675_d();
                    tessellator.func_78381_a();
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
            if (!is.func_190926_b() && s instanceof AppEngSlot) {
                AppEngSlot aeSlot = (AppEngSlot)s;
                if (aeSlot.getIsValid() == AppEngSlot.CalculatedValidity.NotAvailable) {
                    boolean isValid;
                    boolean bl = isValid = s.func_75214_a(is) || s instanceof OutputSlot || s instanceof AppEngCraftingSlot || s instanceof DisabledSlot || s instanceof InaccessibleSlot || s instanceof FakeSlot || s instanceof RestrictedInputSlot || s instanceof SlotDisconnected;
                    if (isValid && s instanceof RestrictedInputSlot) {
                        try {
                            isValid = ((RestrictedInputSlot)s).isValid(is, (World)this.getMinecraft().field_71441_e);
                        }
                        catch (Exception err) {
                            AELog.debug(err);
                        }
                    }
                    aeSlot.setIsValid(isValid ? AppEngSlot.CalculatedValidity.Valid : AppEngSlot.CalculatedValidity.Invalid);
                }
                if (aeSlot.getIsValid() == AppEngSlot.CalculatedValidity.Invalid) {
                    this.setBlitOffset(100);
                    this.itemRenderer.field_77023_b = 100.0f;
                    AEBaseScreen.fill((int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)0x66FF6666);
                    this.setBlitOffset(0);
                    this.itemRenderer.field_77023_b = 0.0f;
                }
            }
            if (s instanceof AppEngSlot) {
                ((AppEngSlot)s).setDisplay(true);
                super.func_146977_a(s);
            } else {
                super.func_146977_a(s);
            }
            return;
        }
        catch (Exception err) {
            AELog.warn("[AppEng] AE prevented crash while drawing slot: " + err.toString(), new Object[0]);
            super.func_146977_a(s);
            return;
        }
    }

    protected boolean isPowered() {
        return true;
    }

    public void bindTexture(String file) {
        ResourceLocation loc = new ResourceLocation("appliedenergistics2", "textures/" + file);
        this.getMinecraft().func_110434_K().func_110577_a(loc);
    }

    public void bindTexture(ResourceLocation loc) {
        this.getMinecraft().func_110434_K().func_110577_a(loc);
    }

    protected Scrollbar getScrollBar() {
        return this.myScrollBar;
    }

    protected void setScrollBar(Scrollbar myScrollBar) {
        this.myScrollBar = myScrollBar;
    }

    protected List<InternalSlotME> getMeSlots() {
        return this.meSlots;
    }
}

