/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.implementations.AESubScreen;
import appeng.client.gui.widgets.NumberBox;
import appeng.container.implementations.CraftAmountContainer;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.CraftRequestPacket;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class CraftAmountScreen
extends AEBaseScreen<CraftAmountContainer> {
    private final AESubScreen subGui;
    private NumberBox amountToCraft;
    private Button next;

    public CraftAmountScreen(CraftAmountContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.subGui = new AESubScreen(this, container.getTarget());
    }

    @Override
    public void init() {
        super.init();
        int a = AEConfig.instance().craftItemsByStackAmounts(0);
        int b = AEConfig.instance().craftItemsByStackAmounts(1);
        int c = AEConfig.instance().craftItemsByStackAmounts(2);
        int d = AEConfig.instance().craftItemsByStackAmounts(3);
        this.addButton((Widget)new Button(this.field_147003_i + 20, this.field_147009_r + 26, 22, 20, "+" + a, btn -> this.addQty(a)));
        this.addButton((Widget)new Button(this.field_147003_i + 48, this.field_147009_r + 26, 28, 20, "+" + b, btn -> this.addQty(b)));
        this.addButton((Widget)new Button(this.field_147003_i + 82, this.field_147009_r + 26, 32, 20, "+" + c, btn -> this.addQty(c)));
        this.addButton((Widget)new Button(this.field_147003_i + 120, this.field_147009_r + 26, 38, 20, "+" + d, btn -> this.addQty(d)));
        this.addButton((Widget)new Button(this.field_147003_i + 20, this.field_147009_r + 75, 22, 20, "-" + a, btn -> this.addQty(-a)));
        this.addButton((Widget)new Button(this.field_147003_i + 48, this.field_147009_r + 75, 28, 20, "-" + b, btn -> this.addQty(-b)));
        this.addButton((Widget)new Button(this.field_147003_i + 82, this.field_147009_r + 75, 32, 20, "-" + c, btn -> this.addQty(-c)));
        this.addButton((Widget)new Button(this.field_147003_i + 120, this.field_147009_r + 75, 38, 20, "-" + d, btn -> this.addQty(-d)));
        this.next = (Button)this.addButton((Widget)new Button(this.field_147003_i + 128, this.field_147009_r + 51, 38, 20, GuiText.Next.getLocal(), this::confirm));
        this.subGui.addBackButton(arg_0 -> ((CraftAmountScreen)this).addButton(arg_0), 154, 0);
        this.font.getClass();
        this.amountToCraft = new NumberBox(this.font, this.field_147003_i + 62, this.field_147009_r + 57, 59, 9, Integer.class);
        this.amountToCraft.func_146185_a(false);
        this.amountToCraft.func_146203_f(16);
        this.amountToCraft.func_146193_g(0xFFFFFF);
        this.amountToCraft.func_146189_e(true);
        this.amountToCraft.func_146195_b(true);
        this.amountToCraft.func_146180_a("1");
    }

    private void confirm(Button button) {
        NetworkHandler.instance().sendToServer(new CraftRequestPacket(Integer.parseInt(this.amountToCraft.func_146179_b()), CraftAmountScreen.hasShiftDown()));
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.font.func_211126_b(GuiText.SelectAmount.getLocal(), 8.0f, 6.0f, 0x404040);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.next.setMessage(CraftAmountScreen.hasShiftDown() ? GuiText.Start.getLocal() : GuiText.Next.getLocal());
        this.bindTexture("guis/craft_amt.png");
        GuiUtils.drawTexturedModalRect((int)offsetX, (int)offsetY, (int)0, (int)0, (int)this.field_146999_f, (int)this.field_147000_g, (float)this.getBlitOffset());
        try {
            Long.parseLong(this.amountToCraft.func_146179_b());
            this.next.active = !this.amountToCraft.func_146179_b().isEmpty();
        }
        catch (NumberFormatException e) {
            this.next.active = false;
        }
        this.amountToCraft.render(offsetX, offsetY, partialTicks);
    }

    public boolean charTyped(char ch, int p_charTyped_2_) {
        return this.amountToCraft.charTyped(ch, p_charTyped_2_);
    }

    public boolean keyPressed(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (!this.checkHotbarKeys(InputMappings.func_197954_a((int)keyCode, (int)scanCode))) {
            if (keyCode == 28) {
                this.next.onPress();
            }
            if ((keyCode == 211 || keyCode == 205 || keyCode == 203 || keyCode == 14) && this.amountToCraft.keyPressed(keyCode, scanCode, p_keyPressed_3_)) {
                try {
                    long result;
                    String out = this.amountToCraft.func_146179_b();
                    boolean fixed = false;
                    while (out.startsWith("0") && out.length() > 1) {
                        out = out.substring(1);
                        fixed = true;
                    }
                    if (fixed) {
                        this.amountToCraft.func_146180_a(out);
                    }
                    if (out.isEmpty()) {
                        out = "0";
                    }
                    if ((result = Long.parseLong(out)) < 0L) {
                        this.amountToCraft.func_146180_a("1");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, p_keyPressed_3_);
    }

    private void addQty(int i) {
        try {
            long result;
            String out = this.amountToCraft.func_146179_b();
            boolean fixed = false;
            while (out.startsWith("0") && out.length() > 1) {
                out = out.substring(1);
                fixed = true;
            }
            if (fixed) {
                this.amountToCraft.func_146180_a(out);
            }
            if (out.isEmpty()) {
                out = "0";
            }
            if ((result = (long)Integer.parseInt(out)) == 1L && i > 1) {
                result = 0L;
            }
            if ((result += (long)i) < 1L) {
                result = 1L;
            }
            out = Long.toString(result);
            Integer.parseInt(out);
            this.amountToCraft.func_146180_a(out);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected String getBackground() {
        return "guis/craftAmt.png";
    }
}

