/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.LevelType;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.widgets.NumberBox;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.container.implementations.LevelEmitterContainer;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class LevelEmitterScreen
extends UpgradeableScreen<LevelEmitterContainer> {
    private NumberBox level;
    private Button plus1;
    private Button plus10;
    private Button plus100;
    private Button plus1000;
    private Button minus1;
    private Button minus10;
    private Button minus100;
    private Button minus1000;
    private SettingToggleButton<LevelType> levelMode;
    private SettingToggleButton<YesNo> craftingMode;

    public LevelEmitterScreen(LevelEmitterContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
    }

    @Override
    public void init() {
        super.init();
        this.font.getClass();
        this.level = new NumberBox(this.font, this.field_147003_i + 24, this.field_147009_r + 43, 79, 9, Long.class);
        this.level.func_146185_a(false);
        this.level.func_146203_f(16);
        this.level.func_146193_g(0xFFFFFF);
        this.level.func_146189_e(true);
        this.level.func_146195_b(true);
        ((LevelEmitterContainer)this.field_147002_h).setTextField(this.level);
    }

    @Override
    protected void addButtons() {
        this.levelMode = new ServerSettingToggleButton<LevelType>(this.field_147003_i - 18, this.field_147009_r + 8, Settings.LEVEL_TYPE, LevelType.ITEM_LEVEL);
        this.redstoneMode = new ServerSettingToggleButton<RedstoneMode>(this.field_147003_i - 18, this.field_147009_r + 28, Settings.REDSTONE_EMITTER, RedstoneMode.LOW_SIGNAL);
        this.fuzzyMode = new ServerSettingToggleButton<FuzzyMode>(this.field_147003_i - 18, this.field_147009_r + 48, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.craftingMode = new ServerSettingToggleButton<YesNo>(this.field_147003_i - 18, this.field_147009_r + 48, Settings.CRAFT_VIA_REDSTONE, YesNo.NO);
        int a = AEConfig.instance().levelByStackAmounts(0);
        int b = AEConfig.instance().levelByStackAmounts(1);
        int c = AEConfig.instance().levelByStackAmounts(2);
        int d = AEConfig.instance().levelByStackAmounts(3);
        this.plus1 = new Button(this.field_147003_i + 20, this.field_147009_r + 17, 22, 20, "+" + a, btn -> this.addQty(a));
        this.addButton((Widget)this.plus1);
        this.plus10 = new Button(this.field_147003_i + 48, this.field_147009_r + 17, 28, 20, "+" + b, btn -> this.addQty(b));
        this.addButton((Widget)this.plus10);
        this.plus100 = new Button(this.field_147003_i + 82, this.field_147009_r + 17, 32, 20, "+" + c, btn -> this.addQty(c));
        this.addButton((Widget)this.plus100);
        this.plus1000 = new Button(this.field_147003_i + 120, this.field_147009_r + 17, 38, 20, "+" + d, btn -> this.addQty(d));
        this.addButton((Widget)this.plus1000);
        this.minus1 = new Button(this.field_147003_i + 20, this.field_147009_r + 59, 22, 20, "-" + a, btn -> this.addQty(-a));
        this.addButton((Widget)this.minus1);
        this.minus10 = new Button(this.field_147003_i + 48, this.field_147009_r + 59, 28, 20, "-" + b, btn -> this.addQty(-b));
        this.addButton((Widget)this.minus10);
        this.minus100 = new Button(this.field_147003_i + 82, this.field_147009_r + 59, 32, 20, "-" + c, btn -> this.addQty(-c));
        this.addButton((Widget)this.minus100);
        this.minus1000 = new Button(this.field_147003_i + 120, this.field_147009_r + 59, 38, 20, "-" + d, btn -> this.addQty(-d));
        this.addButton((Widget)this.minus1000);
        this.addButton((Widget)this.levelMode);
        this.addButton((Widget)this.redstoneMode);
        this.addButton((Widget)this.craftingMode);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        boolean notCraftingMode = this.bc.getInstalledUpgrades(Upgrades.CRAFTING) == 0;
        this.level.func_146184_c(notCraftingMode);
        this.plus1.active = notCraftingMode;
        this.plus10.active = notCraftingMode;
        this.plus100.active = notCraftingMode;
        this.plus1000.active = notCraftingMode;
        this.minus1.active = notCraftingMode;
        this.minus10.active = notCraftingMode;
        this.minus100.active = notCraftingMode;
        this.minus1000.active = notCraftingMode;
        this.levelMode.active = notCraftingMode;
        this.redstoneMode.active = notCraftingMode;
        super.drawFG(offsetX, offsetY, mouseX, mouseY);
        if (this.craftingMode != null) {
            this.craftingMode.set(this.cvb.getCraftingMode());
        }
        if (this.levelMode != null) {
            this.levelMode.set(((LevelEmitterContainer)this.cvb).getLevelMode());
        }
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(offsetX, offsetY, mouseX, mouseY, partialTicks);
        this.level.render(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void handleButtonVisibility() {
        this.craftingMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CRAFTING) > 0);
        this.fuzzyMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.FUZZY) > 0);
    }

    @Override
    protected String getBackground() {
        return "guis/lvlemitter.png";
    }

    @Override
    protected GuiText getName() {
        return GuiText.LevelEmitter;
    }

    private void addQty(long i) {
        try {
            String Out = this.level.func_146179_b();
            boolean Fixed = false;
            while (Out.startsWith("0") && Out.length() > 1) {
                Out = Out.substring(1);
                Fixed = true;
            }
            if (Fixed) {
                this.level.func_146180_a(Out);
            }
            if (Out.isEmpty()) {
                Out = "0";
            }
            long result = Long.parseLong(Out);
            if ((result += i) < 0L) {
                result = 0L;
            }
            Out = Long.toString(result);
            this.level.func_146180_a(Out);
            NetworkHandler.instance().sendToServer(new ConfigValuePacket("LevelEmitter.Value", Out));
        }
        catch (NumberFormatException e) {
            this.level.func_146180_a("0");
        }
    }

    public boolean charTyped(char character, int key) {
        return this.level.charTyped(character, key);
    }

    public boolean keyPressed(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (!(this.checkHotbarKeys(InputMappings.func_197954_a((int)keyCode, (int)scanCode)) || keyCode != 211 && keyCode != 205 && keyCode != 203 && keyCode != 14)) {
            String Out = this.level.func_146179_b();
            boolean Fixed = false;
            while (Out.startsWith("0") && Out.length() > 1) {
                Out = Out.substring(1);
                Fixed = true;
            }
            if (Fixed) {
                this.level.func_146180_a(Out);
            }
            if (Out.isEmpty()) {
                Out = "0";
            }
            NetworkHandler.instance().sendToServer(new ConfigValuePacket("LevelEmitter.Value", Out));
            return true;
        }
        return super.keyPressed(keyCode, scanCode, p_keyPressed_3_);
    }
}

