/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.ActionItems;
import appeng.client.gui.implementations.MEMonitorableScreen;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.TabButton;
import appeng.container.implementations.PatternTermContainer;
import appeng.container.slot.AppEngSlot;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;

public class PatternTermScreen
extends MEMonitorableScreen<PatternTermContainer> {
    private static final String BACKGROUND_CRAFTING_MODE = "guis/pattern.png";
    private static final String BACKGROUND_PROCESSING_MODE = "guis/pattern2.png";
    private static final String SUBSITUTION_DISABLE = "0";
    private static final String SUBSITUTION_ENABLE = "1";
    private static final String CRAFTMODE_CRFTING = "1";
    private static final String CRAFTMODE_PROCESSING = "0";
    private TabButton tabCraftButton;
    private TabButton tabProcessButton;
    private ActionButton substitutionsEnabledBtn;
    private ActionButton substitutionsDisabledBtn;

    public PatternTermScreen(PatternTermContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.setReservedSpace(81);
    }

    @Override
    public void init() {
        super.init();
        this.tabCraftButton = new TabButton(this.field_147003_i + 173, this.field_147009_r + this.field_147000_g - 177, new ItemStack((IItemProvider)Blocks.field_150462_ai), GuiText.CraftingPattern.getLocal(), this.itemRenderer, btn -> this.toggleCraftMode("0"));
        this.addButton((Widget)this.tabCraftButton);
        this.tabProcessButton = new TabButton(this.field_147003_i + 173, this.field_147009_r + this.field_147000_g - 177, new ItemStack((IItemProvider)Blocks.field_150460_al), GuiText.ProcessingPattern.getLocal(), this.itemRenderer, btn -> this.toggleCraftMode("1"));
        this.addButton((Widget)this.tabProcessButton);
        this.substitutionsEnabledBtn = new ActionButton(this.field_147003_i + 84, this.field_147009_r + this.field_147000_g - 163, ActionItems.ENABLE_SUBSTITUTION, act -> this.toggleSubstitutions("0"));
        this.substitutionsEnabledBtn.setHalfSize(true);
        this.addButton((Widget)this.substitutionsEnabledBtn);
        this.substitutionsDisabledBtn = new ActionButton(this.field_147003_i + 84, this.field_147009_r + this.field_147000_g - 163, ActionItems.DISABLE_SUBSTITUTION, act -> this.toggleSubstitutions("1"));
        this.substitutionsDisabledBtn.setHalfSize(true);
        this.addButton((Widget)this.substitutionsDisabledBtn);
        ActionButton clearBtn = new ActionButton(this.field_147003_i + 74, this.field_147009_r + this.field_147000_g - 163, ActionItems.CLOSE, act -> this.clear());
        clearBtn.setHalfSize(true);
        this.addButton((Widget)clearBtn);
        ActionButton encodeBtn = new ActionButton(this.field_147003_i + 147, this.field_147009_r + this.field_147000_g - 142, ActionItems.ENCODE, act -> this.encode());
        this.addButton((Widget)encodeBtn);
    }

    private void toggleCraftMode(String mode) {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.CraftMode", mode));
    }

    private void toggleSubstitutions(String mode) {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.Substitute", mode));
    }

    private void encode() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.Encode", "1"));
    }

    private void clear() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.Clear", "1"));
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        if (((PatternTermContainer)this.field_147002_h).isCraftingMode()) {
            this.tabCraftButton.visible = true;
            this.tabProcessButton.visible = false;
            if (((PatternTermContainer)this.field_147002_h).substitute) {
                this.substitutionsEnabledBtn.visible = true;
                this.substitutionsDisabledBtn.visible = false;
            } else {
                this.substitutionsEnabledBtn.visible = false;
                this.substitutionsDisabledBtn.visible = true;
            }
        } else {
            this.tabCraftButton.visible = false;
            this.tabProcessButton.visible = true;
            this.substitutionsEnabledBtn.visible = false;
            this.substitutionsDisabledBtn.visible = false;
        }
        super.drawFG(offsetX, offsetY, mouseX, mouseY);
        this.font.func_211126_b(GuiText.PatternTerminal.getLocal(), 8.0f, (float)(this.field_147000_g - 96 + 2 - this.getReservedSpace()), 0x404040);
    }

    @Override
    protected String getBackground() {
        if (((PatternTermContainer)this.field_147002_h).isCraftingMode()) {
            return BACKGROUND_CRAFTING_MODE;
        }
        return BACKGROUND_PROCESSING_MODE;
    }

    @Override
    protected void repositionSlot(AppEngSlot s) {
        int offsetPlayerSide = s.isPlayerSide() ? 5 : 3;
        s.field_75221_f = s.getY() + this.field_147000_g - 78 - offsetPlayerSide;
    }
}

