/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.AccessRestriction;
import appeng.api.config.ActionItems;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.TabButton;
import appeng.container.implementations.PriorityContainer;
import appeng.container.implementations.StorageBusContainer;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.SwitchGuisPacket;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class StorageBusScreen
extends UpgradeableScreen<StorageBusContainer> {
    private SettingToggleButton<AccessRestriction> rwMode;
    private SettingToggleButton<StorageFilter> storageFilter;

    public StorageBusScreen(StorageBusContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.field_147000_g = 251;
    }

    @Override
    protected void addButtons() {
        this.addButton((Widget)new ActionButton(this.field_147003_i - 18, this.field_147009_r + 8, ActionItems.CLOSE, btn -> this.clear()));
        this.addButton((Widget)new ActionButton(this.field_147003_i - 18, this.field_147009_r + 28, ActionItems.WRENCH, btn -> this.partition()));
        this.rwMode = new ServerSettingToggleButton<AccessRestriction>(this.field_147003_i - 18, this.field_147009_r + 48, Settings.ACCESS, AccessRestriction.READ_WRITE);
        this.storageFilter = new ServerSettingToggleButton<StorageFilter>(this.field_147003_i - 18, this.field_147009_r + 68, Settings.STORAGE_FILTER, StorageFilter.EXTRACTABLE_ONLY);
        this.fuzzyMode = new ServerSettingToggleButton<FuzzyMode>(this.field_147003_i - 18, this.field_147009_r + 88, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.addButton((Widget)new TabButton(this.field_147003_i + 154, this.field_147009_r, 66, GuiText.Priority.getLocal(), this.itemRenderer, btn -> this.openPriorityGui()));
        this.addButton((Widget)this.storageFilter);
        this.addButton((Widget)this.fuzzyMode);
        this.addButton((Widget)this.rwMode);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.font.func_211126_b(this.getGuiDisplayName(GuiText.StorageBus.getLocal()), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(GuiText.inventory.getLocal(), 8.0f, (float)(this.field_147000_g - 96 + 3), 0x404040);
        if (this.fuzzyMode != null) {
            this.fuzzyMode.set(this.cvb.getFuzzyMode());
        }
        if (this.storageFilter != null) {
            this.storageFilter.set(((StorageBusContainer)this.cvb).getStorageFilter());
        }
        if (this.rwMode != null) {
            this.rwMode.set(((StorageBusContainer)this.cvb).getReadWriteMode());
        }
    }

    @Override
    protected String getBackground() {
        return "guis/storagebus.png";
    }

    private void partition() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("StorageBus.Action", "Partition"));
    }

    private void clear() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("StorageBus.Action", "Clear"));
    }

    private void openPriorityGui() {
        NetworkHandler.instance().sendToServer(new SwitchGuisPacket(PriorityContainer.TYPE));
    }
}

