/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.UpgradeableContainer;
import appeng.core.localization.GuiText;
import appeng.parts.automation.ExportBusPart;
import appeng.parts.automation.ImportBusPart;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class UpgradeableScreen<T extends UpgradeableContainer>
extends AEBaseScreen<T> {
    protected final UpgradeableContainer cvb;
    protected final IUpgradeableHost bc;
    protected SettingToggleButton<RedstoneMode> redstoneMode;
    protected SettingToggleButton<FuzzyMode> fuzzyMode;
    protected SettingToggleButton<YesNo> craftMode;
    protected SettingToggleButton<SchedulingMode> schedulingMode;

    public UpgradeableScreen(T container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.cvb = container;
        this.bc = (IUpgradeableHost)((AEBaseContainer)((Object)container)).getTarget();
        this.field_146999_f = this.hasToolbox() ? 246 : 211;
        this.field_147000_g = 184;
    }

    protected boolean hasToolbox() {
        return ((UpgradeableContainer)this.field_147002_h).hasToolbox();
    }

    @Override
    public void init() {
        super.init();
        this.addButtons();
    }

    protected void addButtons() {
        this.redstoneMode = new ServerSettingToggleButton<RedstoneMode>(this.field_147003_i - 18, this.field_147009_r + 8, Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.addButton((Widget)this.redstoneMode);
        this.fuzzyMode = new ServerSettingToggleButton<FuzzyMode>(this.field_147003_i - 18, this.field_147009_r + 28, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.addButton((Widget)this.fuzzyMode);
        this.craftMode = new ServerSettingToggleButton<YesNo>(this.field_147003_i - 18, this.field_147009_r + 48, Settings.CRAFT_ONLY, YesNo.NO);
        this.addButton((Widget)this.craftMode);
        this.schedulingMode = new ServerSettingToggleButton<SchedulingMode>(this.field_147003_i - 18, this.field_147009_r + 68, Settings.SCHEDULING_MODE, SchedulingMode.DEFAULT);
        this.addButton((Widget)this.schedulingMode);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.font.func_211126_b(this.getGuiDisplayName(this.getName().getLocal()), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(GuiText.inventory.getLocal(), 8.0f, (float)(this.field_147000_g - 96 + 3), 0x404040);
        if (this.redstoneMode != null) {
            this.redstoneMode.set(this.cvb.getRedStoneMode());
        }
        if (this.fuzzyMode != null) {
            this.fuzzyMode.set(this.cvb.getFuzzyMode());
        }
        if (this.craftMode != null) {
            this.craftMode.set(this.cvb.getCraftingMode());
        }
        if (this.schedulingMode != null) {
            this.schedulingMode.set(this.cvb.getSchedulingMode());
        }
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.handleButtonVisibility();
        this.bindTexture(this.getBackground());
        GuiUtils.drawTexturedModalRect((int)offsetX, (int)offsetY, (int)0, (int)0, (int)177, (int)this.field_147000_g, (float)this.getBlitOffset());
        if (this.drawUpgrades()) {
            GuiUtils.drawTexturedModalRect((int)(offsetX + 177), (int)offsetY, (int)177, (int)0, (int)35, (int)(14 + this.cvb.availableUpgrades() * 18), (float)this.getBlitOffset());
        }
        if (this.hasToolbox()) {
            GuiUtils.drawTexturedModalRect((int)(offsetX + 178), (int)(offsetY + this.field_147000_g - 90), (int)178, (int)(this.field_147000_g - 90), (int)68, (int)68, (float)this.getBlitOffset());
        }
    }

    protected void handleButtonVisibility() {
        if (this.redstoneMode != null) {
            this.redstoneMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.REDSTONE) > 0);
        }
        if (this.fuzzyMode != null) {
            this.fuzzyMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.FUZZY) > 0);
        }
        if (this.craftMode != null) {
            this.craftMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CRAFTING) > 0);
        }
        if (this.schedulingMode != null) {
            this.schedulingMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CAPACITY) > 0 && this.bc instanceof ExportBusPart);
        }
    }

    protected String getBackground() {
        return "guis/bus.png";
    }

    protected boolean drawUpgrades() {
        return true;
    }

    protected GuiText getName() {
        return this.bc instanceof ImportBusPart ? GuiText.ImportBus : GuiText.ExportBus;
    }
}

