/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.widgets.ITooltip;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.gui.GuiUtils;

public abstract class IconButton
extends Button
implements ITooltip {
    public static final ResourceLocation TEXTURE_STATES = new ResourceLocation("appliedenergistics2", "textures/guis/states.png");
    private boolean halfSize = false;

    public IconButton(int x, int y, Button.IPressable onPress) {
        super(x, y, 16, 16, "", onPress);
    }

    public void setVisibility(boolean vis) {
        this.visible = vis;
        this.active = vis;
    }

    public void renderButton(int mouseX, int mouseY, float partial) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (this.visible) {
            int iconIndex = this.getIconIndex();
            TextureManager textureManager = minecraft.func_110434_K();
            textureManager.func_110577_a(TEXTURE_STATES);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            if (this.halfSize) {
                this.width = 8;
                this.height = 8;
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)this.x, (float)this.y, (float)0.0f);
                RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                if (this.active) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                }
                int uv_y = iconIndex / 16;
                int uv_x = iconIndex - uv_y * 16;
                GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)240, (int)240, (int)16, (int)16, (float)0.0f);
                GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)(uv_x * 16), (int)(uv_y * 16), (int)16, (int)16, (float)0.0f);
                RenderSystem.popMatrix();
            } else {
                if (this.active) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                }
                int uv_y = iconIndex / 16;
                int uv_x = iconIndex - uv_y * 16;
                GuiUtils.drawTexturedModalRect((int)this.x, (int)this.y, (int)240, (int)240, (int)16, (int)16, (float)0.0f);
                GuiUtils.drawTexturedModalRect((int)this.x, (int)this.y, (int)(uv_x * 16), (int)(uv_y * 16), (int)16, (int)16, (float)0.0f);
            }
            RenderSystem.enableDepthTest();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected abstract int getIconIndex();

    @Override
    public int xPos() {
        return this.x;
    }

    @Override
    public int yPos() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.halfSize ? 8 : 16;
    }

    @Override
    public int getHeight() {
        return this.halfSize ? 8 : 16;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public boolean isHalfSize() {
        return this.halfSize;
    }

    public void setHalfSize(boolean halfSize) {
        this.halfSize = halfSize;
    }
}

