/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.widgets.ITooltip;
import appeng.container.interfaces.IProgressProvider;
import appeng.core.localization.GuiText;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class ProgressBar
extends Widget
implements ITooltip {
    private final IProgressProvider source;
    private final ResourceLocation texture;
    private final int fill_u;
    private final int fill_v;
    private final Direction layout;
    private final String titleName;
    private String fullMsg;

    public ProgressBar(IProgressProvider source, String texture, int posX, int posY, int u, int y, int width, int height, Direction dir) {
        this(source, texture, posX, posY, u, y, width, height, dir, null);
    }

    public ProgressBar(IProgressProvider source, String texture, int posX, int posY, int u, int y, int width, int height, Direction dir, String title) {
        super(posX, posY, width, height, "");
        this.source = source;
        this.texture = new ResourceLocation("appliedenergistics2", "textures/" + texture);
        this.fill_u = u;
        this.fill_v = y;
        this.layout = dir;
        this.titleName = title;
    }

    public void renderButton(int par2, int par3, float partial) {
        if (this.visible) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
            int max = this.source.getMaxProgress();
            int current = this.source.getCurrentProgress();
            if (this.layout == Direction.VERTICAL) {
                int diff = this.height - (max > 0 ? this.height * current / max : 0);
                GuiUtils.drawTexturedModalRect((int)this.x, (int)(this.y + diff), (int)this.fill_u, (int)(this.fill_v + diff), (int)this.width, (int)(this.height - diff), (float)0.0f);
            } else {
                int diff = this.width - (max > 0 ? this.width * current / max : 0);
                GuiUtils.drawTexturedModalRect((int)this.x, (int)this.y, (int)(this.fill_u + diff), (int)this.fill_v, (int)(this.width - diff), (int)this.height, (float)0.0f);
            }
        }
    }

    public void setFullMsg(String msg) {
        this.fullMsg = msg;
    }

    @Override
    public String getMessage() {
        if (this.fullMsg != null) {
            return this.fullMsg;
        }
        return (this.titleName != null ? this.titleName : "") + '\n' + this.source.getCurrentProgress() + ' ' + GuiText.Of.getLocal() + ' ' + this.source.getMaxProgress();
    }

    @Override
    public int xPos() {
        return this.x - 2;
    }

    @Override
    public int yPos() {
        return this.y - 2;
    }

    @Override
    public int getWidth() {
        return this.width + 4;
    }

    @Override
    public int getHeight() {
        return this.height + 4;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

