/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.storage.data.IAEItemStack;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.util.ISlimReadableNumberConverter;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.ReadableNumberConverter;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;

public class StackSizeRenderer {
    private static final ISlimReadableNumberConverter SLIM_CONVERTER = ReadableNumberConverter.INSTANCE;
    private static final IWideReadableNumberConverter WIDE_CONVERTER = ReadableNumberConverter.INSTANCE;

    public void renderStackSize(FontRenderer fontRenderer, IAEItemStack aeStack, int xPos, int yPos) {
        if (aeStack != null) {
            if (aeStack.getStackSize() == 0L && aeStack.isCraftable()) {
                String craftLabelText = AEConfig.instance().isUseLargeFonts() ? GuiText.LargeFontCraft.getLocal() : GuiText.SmallFontCraft.getLocal();
                StackSizeRenderer.renderSizeLabel(fontRenderer, xPos, yPos, craftLabelText);
            }
            if (aeStack.getStackSize() > 0L) {
                String stackSize = this.getToBeRenderedStackSize(aeStack.getStackSize());
                StackSizeRenderer.renderSizeLabel(fontRenderer, xPos, yPos, stackSize);
            }
        }
    }

    public static void renderSizeLabel(FontRenderer fontRenderer, float xPos, float yPos, String text) {
        float scaleFactor = AEConfig.instance().isUseLargeFonts() ? 0.85f : 0.5f;
        float inverseScaleFactor = 1.0f / scaleFactor;
        int offset = AEConfig.instance().isUseLargeFonts() ? 0 : -1;
        TransformationMatrix tm = new TransformationMatrix(new Vector3f(0.0f, 0.0f, 300.0f), null, new Vector3f(scaleFactor, scaleFactor, scaleFactor), null);
        RenderSystem.disableBlend();
        int X = (int)((xPos + (float)offset + 16.0f - (float)fontRenderer.func_78256_a(text) * scaleFactor) * inverseScaleFactor);
        int Y = (int)((yPos + (float)offset + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        fontRenderer.func_228079_a_(text, (float)X, (float)Y, 0xFFFFFF, true, tm.func_227988_c_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
        buffer.func_228461_a_();
        RenderSystem.enableBlend();
    }

    private String getToBeRenderedStackSize(long originalSize) {
        if (AEConfig.instance().isUseLargeFonts()) {
            return SLIM_CONVERTER.toSlimReadableForm(originalSize);
        }
        return WIDE_CONVERTER.toWideReadableForm(originalSize);
    }
}

