/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.client.render.cablebus.CableBuilder;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.client.render.cablebus.CableCoreType;
import appeng.client.render.cablebus.FacadeBuilder;
import appeng.client.render.cablebus.QuadRotator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class CableBusBakedModel
implements IBakedModel {
    private static final Map<CableBusRenderState, List<BakedQuad>> CABLE_MODEL_CACHE = new HashMap<CableBusRenderState, List<BakedQuad>>();
    private final CableBuilder cableBuilder;
    private final FacadeBuilder facadeBuilder;
    private final Map<ResourceLocation, IBakedModel> partModels;
    private final TextureAtlasSprite particleTexture;

    CableBusBakedModel(CableBuilder cableBuilder, FacadeBuilder facadeBuilder, Map<ResourceLocation, IBakedModel> partModels, TextureAtlasSprite particleTexture) {
        this.cableBuilder = cableBuilder;
        this.facadeBuilder = facadeBuilder;
        this.partModels = partModels;
        this.particleTexture = particleTexture;
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
        CableBusRenderState renderState = (CableBusRenderState)data.getData(CableBusRenderState.PROPERTY);
        if (renderState == null || side != null) {
            return Collections.emptyList();
        }
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (layer == RenderType.func_228643_e_()) {
            List cableModel = CABLE_MODEL_CACHE.computeIfAbsent(renderState, k -> {
                ArrayList<BakedQuad> model = new ArrayList<BakedQuad>();
                this.addCableQuads(renderState, model);
                return model;
            });
            quads.addAll(cableModel);
            for (Direction facing : Direction.values()) {
                IPartModel partModel = renderState.getAttachments().get(facing);
                if (partModel == null) continue;
                IModelData partModelData = renderState.getPartModelData().get(facing);
                if (partModelData == null) {
                    partModelData = EmptyModelData.INSTANCE;
                }
                for (ResourceLocation model : partModel.getModels()) {
                    IBakedModel bakedModel = this.partModels.get(model);
                    if (bakedModel == null) {
                        throw new IllegalStateException("Trying to use an unregistered part model: " + model);
                    }
                    List<BakedQuad> partQuads = bakedModel.getQuads(state, null, rand, partModelData);
                    QuadRotator rotator = new QuadRotator();
                    partQuads = rotator.rotateQuads(partQuads, facing, Direction.UP);
                    quads.addAll(partQuads);
                }
            }
        }
        this.facadeBuilder.buildFacadeQuads(layer, renderState, rand, quads, this.partModels::get);
        return quads;
    }

    private static boolean isStraightLine(AECableType cableType, EnumMap<Direction, AECableType> sides) {
        Iterator<Map.Entry<Direction, AECableType>> it = sides.entrySet().iterator();
        if (!it.hasNext()) {
            return false;
        }
        Map.Entry<Direction, AECableType> nextConnection = it.next();
        Direction firstSide = nextConnection.getKey();
        AECableType firstType = nextConnection.getValue();
        if (!it.hasNext()) {
            return false;
        }
        if (firstSide.func_176734_d() != it.next().getKey()) {
            return false;
        }
        if (it.hasNext()) {
            return false;
        }
        AECableType secondType = sides.get(firstSide.func_176734_d());
        return firstType == secondType && cableType == firstType && cableType == secondType;
    }

    private void addCableQuads(CableBusRenderState renderState, List<BakedQuad> quadsOut) {
        boolean noAttachments;
        AECableType cableType = renderState.getCableType();
        if (cableType == AECableType.NONE) {
            return;
        }
        AEColor cableColor = renderState.getCableColor();
        EnumMap<Direction, AECableType> connectionTypes = renderState.getConnectionTypes();
        boolean bl = noAttachments = !renderState.getAttachments().values().stream().anyMatch(IPartModel::requireCableConnection);
        if (noAttachments && CableBusBakedModel.isStraightLine(cableType, connectionTypes)) {
            Direction facing = connectionTypes.keySet().iterator().next();
            switch (cableType) {
                case GLASS: {
                    this.cableBuilder.addStraightGlassConnection(facing, cableColor, quadsOut);
                    break;
                }
                case COVERED: {
                    this.cableBuilder.addStraightCoveredConnection(facing, cableColor, quadsOut);
                    break;
                }
                case SMART: {
                    this.cableBuilder.addStraightSmartConnection(facing, cableColor, renderState.getChannelsOnSide().get(facing), quadsOut);
                    break;
                }
                case DENSE_COVERED: {
                    this.cableBuilder.addStraightDenseCoveredConnection(facing, cableColor, quadsOut);
                    break;
                }
                case DENSE_SMART: {
                    this.cableBuilder.addStraightDenseSmartConnection(facing, cableColor, renderState.getChannelsOnSide().get(facing), quadsOut);
                    break;
                }
            }
            return;
        }
        this.cableBuilder.addCableCore(renderState.getCoreType(), cableColor, quadsOut);
        EnumMap<Direction, Integer> attachmentConnections = renderState.getAttachmentConnections();
        for (Direction direction : attachmentConnections.keySet()) {
            int distance = attachmentConnections.get(direction);
            int channels = renderState.getChannelsOnSide().get(direction);
            switch (cableType) {
                case GLASS: {
                    this.cableBuilder.addConstrainedGlassConnection(direction, cableColor, distance, quadsOut);
                    break;
                }
                case COVERED: {
                    this.cableBuilder.addConstrainedCoveredConnection(direction, cableColor, distance, quadsOut);
                    break;
                }
                case SMART: {
                    this.cableBuilder.addConstrainedSmartConnection(direction, cableColor, distance, channels, quadsOut);
                    break;
                }
                case DENSE_COVERED: 
                case DENSE_SMART: {
                    break;
                }
            }
        }
        for (Map.Entry entry : connectionTypes.entrySet()) {
            Direction facing = (Direction)entry.getKey();
            AECableType connectionType = (AECableType)((Object)entry.getValue());
            boolean cableBusAdjacent = renderState.getCableBusAdjacent().contains(facing);
            int channels = renderState.getChannelsOnSide().get(facing);
            switch (cableType) {
                case GLASS: {
                    this.cableBuilder.addGlassConnection(facing, cableColor, connectionType, cableBusAdjacent, quadsOut);
                    break;
                }
                case COVERED: {
                    this.cableBuilder.addCoveredConnection(facing, cableColor, connectionType, cableBusAdjacent, quadsOut);
                    break;
                }
                case SMART: {
                    this.cableBuilder.addSmartConnection(facing, cableColor, connectionType, cableBusAdjacent, channels, quadsOut);
                    break;
                }
                case DENSE_COVERED: {
                    this.cableBuilder.addDenseCoveredConnection(facing, cableColor, connectionType, cableBusAdjacent, quadsOut);
                    break;
                }
                case DENSE_SMART: {
                    this.cableBuilder.addDenseSmartConnection(facing, cableColor, connectionType, cableBusAdjacent, channels, quadsOut);
                    break;
                }
            }
        }
    }

    public List<TextureAtlasSprite> getParticleTextures(CableBusRenderState renderState) {
        CableCoreType coreType = CableCoreType.fromCableType(renderState.getCableType());
        AEColor cableColor = renderState.getCableColor();
        ArrayList<TextureAtlasSprite> result = new ArrayList<TextureAtlasSprite>();
        if (coreType != null) {
            result.add(this.cableBuilder.getCoreTexture(coreType, cableColor));
        }
        for (Direction side : renderState.getAttachments().keySet()) {
            IPartModel partModel = renderState.getAttachments().get(side);
            for (ResourceLocation model : partModel.getModels()) {
                IBakedModel bakedModel = this.partModels.get(model);
                if (bakedModel == null) {
                    throw new IllegalStateException("Trying to use an unregistered part model: " + model);
                }
                TextureAtlasSprite particleTexture = bakedModel.func_177554_e();
                if (this.isMissingTexture(particleTexture)) continue;
                result.add(particleTexture);
            }
        }
        return result;
    }

    private boolean isMissingTexture(TextureAtlasSprite particleTexture) {
        return particleTexture instanceof MissingTextureSprite;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particleTexture;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public static void clearCache() {
        CABLE_MODEL_CACHE.clear();
    }
}

