/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.util.AEColor;
import appeng.client.render.cablebus.CableBuilder;
import appeng.client.render.cablebus.CableBusBakedModel;
import appeng.client.render.cablebus.CableCoreType;
import appeng.client.render.cablebus.FacadeBuilder;
import appeng.core.AELog;
import appeng.core.features.registries.PartModels;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class CableBusModel
implements IModelGeometry<CableBusModel> {
    private final PartModels partModels;

    public CableBusModel(PartModels partModels) {
        this.partModels = partModels;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        Map<ResourceLocation, IBakedModel> partModels = this.loadPartModels(bakery, spriteGetter, modelTransform);
        CableBuilder cableBuilder = new CableBuilder(spriteGetter);
        FacadeBuilder facadeBuilder = new FacadeBuilder();
        TextureAtlasSprite particleTexture = cableBuilder.getCoreTexture(CableCoreType.GLASS, AEColor.TRANSPARENT);
        return new CableBusBakedModel(cableBuilder, facadeBuilder, partModels, particleTexture);
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return Collections.unmodifiableList(CableBuilder.getTextures());
    }

    private Map<ResourceLocation, IBakedModel> loadPartModels(ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetterIn, IModelTransform transformIn) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (ResourceLocation location : this.partModels.getModels()) {
            IBakedModel bakedModel = bakery.getBakedModel(location, transformIn, spriteGetterIn);
            if (bakedModel == null) {
                AELog.warn("Failed to bake part model {}", location);
                continue;
            }
            result.put((Object)location, (Object)bakedModel);
        }
        return result.build();
    }
}

