/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.util.AEColor;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.client.render.cablebus.P2PTunnelFrequencyModelData;
import appeng.util.Platform;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class P2PTunnelFrequencyBakedModel
implements IDynamicBakedModel {
    private final TextureAtlasSprite texture;
    private static final Cache<Long, List<BakedQuad>> modelCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private static final int[][] QUAD_OFFSETS = new int[][]{{4, 10, 2}, {10, 10, 2}, {4, 4, 2}, {10, 4, 2}};

    public P2PTunnelFrequencyBakedModel(TextureAtlasSprite texture) {
        this.texture = texture;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData modelData) {
        if (side != null || !(modelData instanceof P2PTunnelFrequencyModelData)) {
            return Collections.emptyList();
        }
        P2PTunnelFrequencyModelData freqModelData = (P2PTunnelFrequencyModelData)modelData;
        return this.getPartQuads(freqModelData.getFrequency());
    }

    private List<BakedQuad> getQuadsForFrequency(short frequency, boolean active) {
        AEColor[] colors = Platform.p2p().toColors(frequency);
        CubeBuilder cb = new CubeBuilder();
        cb.setTexture(this.texture);
        cb.useStandardUV();
        cb.setRenderFullBright(active);
        for (int i = 0; i < 4; ++i) {
            int[] offs = QUAD_OFFSETS[i];
            for (int j = 0; j < 4; ++j) {
                AEColor c = colors[j];
                if (active) {
                    cb.setColorRGB(c.dye.getColorValue());
                } else {
                    float[] cv = c.dye.func_193349_f();
                    cb.setColorRGB(cv[0] * 0.5f, cv[1] * 0.5f, cv[2] * 0.5f);
                }
                int startx = j % 2;
                int starty = 1 - j / 2;
                cb.addCube(offs[0] + startx, offs[1] + starty, offs[2], offs[0] + startx + 1, offs[1] + starty + 1, offs[2] + 1);
            }
        }
        return cb.getOutput();
    }

    private List<BakedQuad> getPartQuads(long partFlags) {
        try {
            return (List)modelCache.get((Object)partFlags, () -> {
                short frequency = (short)(partFlags & 0xFFFFL);
                boolean active = (partFlags & 0x10000L) != 0L;
                return this.getQuadsForFrequency(frequency, active);
            });
        }
        catch (ExecutionException e) {
            return Collections.emptyList();
        }
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.texture;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

