/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.client.render.FacingToRotation;
import appeng.thirdparty.codechicken.lib.model.CachedFormat;
import appeng.thirdparty.codechicken.lib.model.Quad;
import appeng.thirdparty.codechicken.lib.model.pipeline.BakedPipeline;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadMatrixTransformer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class QuadRotator {
    private static final ThreadLocal<BakedPipeline> pipelines = ThreadLocal.withInitial(() -> BakedPipeline.builder().addElement("transformer", QuadMatrixTransformer.FACTORY).build());
    private static final ThreadLocal<Quad> collectors = ThreadLocal.withInitial(Quad::new);

    public List<BakedQuad> rotateQuads(List<BakedQuad> quads, Direction newForward, Direction newUp) {
        if (newForward == Direction.NORTH && newUp == Direction.UP) {
            return quads;
        }
        FacingToRotation rotation = this.getRotation(newForward, newUp);
        if (rotation.isRedundant()) {
            return quads;
        }
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(quads.size());
        CachedFormat format = CachedFormat.lookup(DefaultVertexFormats.field_176600_a);
        BakedPipeline pipeline = pipelines.get();
        Quad collector = collectors.get();
        QuadMatrixTransformer transformer = pipeline.getElement("transformer", QuadMatrixTransformer.class);
        Matrix4f mat = new Matrix4f();
        mat.setTranslation(-0.5f, -0.5f, -0.5f);
        mat.multiplyBackward(rotation.getMat());
        mat.func_226597_a_(new Vector3f(0.5f, 0.5f, 0.5f));
        for (BakedQuad quad : quads) {
            pipeline.reset(format);
            collector.reset(format);
            transformer.setMatrix(mat);
            pipeline.prepare(collector);
            quad.pipe((IVertexConsumer)pipeline);
            result.add(collector.bake());
        }
        return result;
    }

    private FacingToRotation getRotation(Direction forward, Direction up) {
        if (forward.func_176740_k() == up.func_176740_k()) {
            up = up.func_176740_k() == Direction.Axis.Y ? Direction.NORTH : Direction.UP;
        }
        return FacingToRotation.get(forward, up);
    }
}

