/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.crafting;

import appeng.block.crafting.AbstractCraftingUnitBlock;
import appeng.client.render.crafting.LightBakedModel;
import appeng.client.render.crafting.MonitorBakedModel;
import appeng.client.render.crafting.UnitBakedModel;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

class CraftingCubeModel
implements IModelGeometry<CraftingCubeModel> {
    private static final Material RING_CORNER = CraftingCubeModel.texture("ring_corner");
    private static final Material RING_SIDE_HOR = CraftingCubeModel.texture("ring_side_hor");
    private static final Material RING_SIDE_VER = CraftingCubeModel.texture("ring_side_ver");
    private static final Material UNIT_BASE = CraftingCubeModel.texture("unit_base");
    private static final Material LIGHT_BASE = CraftingCubeModel.texture("light_base");
    private static final Material ACCELERATOR_LIGHT = CraftingCubeModel.texture("accelerator_light");
    private static final Material STORAGE_1K_LIGHT = CraftingCubeModel.texture("1k_storage_light");
    private static final Material STORAGE_4K_LIGHT = CraftingCubeModel.texture("4k_storage_light");
    private static final Material STORAGE_16K_LIGHT = CraftingCubeModel.texture("16k_storage_light");
    private static final Material STORAGE_64K_LIGHT = CraftingCubeModel.texture("64k_storage_light");
    private static final Material MONITOR_BASE = CraftingCubeModel.texture("monitor_base");
    private static final Material MONITOR_LIGHT_DARK = CraftingCubeModel.texture("monitor_light_dark");
    private static final Material MONITOR_LIGHT_MEDIUM = CraftingCubeModel.texture("monitor_light_medium");
    private static final Material MONITOR_LIGHT_BRIGHT = CraftingCubeModel.texture("monitor_light_bright");
    private final AbstractCraftingUnitBlock.CraftingUnitType type;

    CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType type) {
        this.type = type;
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return ImmutableList.of((Object)RING_CORNER, (Object)RING_SIDE_HOR, (Object)RING_SIDE_VER, (Object)UNIT_BASE, (Object)LIGHT_BASE, (Object)ACCELERATOR_LIGHT, (Object)STORAGE_1K_LIGHT, (Object)STORAGE_4K_LIGHT, (Object)STORAGE_16K_LIGHT, (Object)STORAGE_64K_LIGHT, (Object)MONITOR_BASE, (Object)MONITOR_LIGHT_DARK, (Object[])new Material[]{MONITOR_LIGHT_MEDIUM, MONITOR_LIGHT_BRIGHT});
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite ringCorner = spriteGetter.apply(RING_CORNER);
        TextureAtlasSprite ringSideHor = spriteGetter.apply(RING_SIDE_HOR);
        TextureAtlasSprite ringSideVer = spriteGetter.apply(RING_SIDE_VER);
        switch (this.type) {
            case UNIT: {
                return new UnitBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(UNIT_BASE));
            }
            case ACCELERATOR: 
            case STORAGE_1K: 
            case STORAGE_4K: 
            case STORAGE_16K: 
            case STORAGE_64K: {
                return new LightBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(LIGHT_BASE), CraftingCubeModel.getLightTexture(spriteGetter, this.type));
            }
            case MONITOR: {
                return new MonitorBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(UNIT_BASE), spriteGetter.apply(MONITOR_BASE), spriteGetter.apply(MONITOR_LIGHT_DARK), spriteGetter.apply(MONITOR_LIGHT_MEDIUM), spriteGetter.apply(MONITOR_LIGHT_BRIGHT));
            }
        }
        throw new IllegalArgumentException("Unsupported crafting unit type: " + (Object)((Object)this.type));
    }

    private static TextureAtlasSprite getLightTexture(Function<Material, TextureAtlasSprite> textureGetter, AbstractCraftingUnitBlock.CraftingUnitType type) {
        switch (type) {
            case ACCELERATOR: {
                return textureGetter.apply(ACCELERATOR_LIGHT);
            }
            case STORAGE_1K: {
                return textureGetter.apply(STORAGE_1K_LIGHT);
            }
            case STORAGE_4K: {
                return textureGetter.apply(STORAGE_4K_LIGHT);
            }
            case STORAGE_16K: {
                return textureGetter.apply(STORAGE_16K_LIGHT);
            }
            case STORAGE_64K: {
                return textureGetter.apply(STORAGE_64K_LIGHT);
            }
        }
        throw new IllegalArgumentException("Crafting unit type " + (Object)((Object)type) + " does not use a light texture.");
    }

    private static Material texture(String name) {
        return new Material(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2", "block/crafting/" + name));
    }
}

