/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.effects;

import appeng.client.render.effects.ParticleTypes;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.Vec3d;

public class LightningArcParticleData
implements IParticleData {
    public final Vec3d target;
    public static final IParticleData.IDeserializer<LightningArcParticleData> DESERIALIZER = new IParticleData.IDeserializer<LightningArcParticleData>(){

        public LightningArcParticleData deserialize(ParticleType<LightningArcParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float x = reader.readFloat();
            reader.expect(' ');
            float y = reader.readFloat();
            reader.expect(' ');
            float z = reader.readFloat();
            return new LightningArcParticleData(new Vec3d((double)x, (double)y, (double)z));
        }

        public LightningArcParticleData read(ParticleType<LightningArcParticleData> particleTypeIn, PacketBuffer buffer) {
            float x = buffer.readFloat();
            float y = buffer.readFloat();
            float z = buffer.readFloat();
            return new LightningArcParticleData(new Vec3d((double)x, (double)y, (double)z));
        }
    };

    public LightningArcParticleData(Vec3d target) {
        this.target = target;
    }

    public ParticleType<?> func_197554_b() {
        return ParticleTypes.LIGHTNING_ARC;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFloat((float)this.target.field_72450_a);
        buffer.writeFloat((float)this.target.field_72448_b);
        buffer.writeFloat((float)this.target.field_72449_c);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%.2f %.2f %.2f", this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c);
    }
}

