/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.api.client.ICellModelRegistry;
import appeng.client.render.model.DriveBakedModel;
import appeng.core.Api;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class DriveModel
implements IModelGeometry<DriveModel> {
    private static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2:block/drive/drive_base");
    private static final ResourceLocation MODEL_CELL_EMPTY = new ResourceLocation("appliedenergistics2:block/drive/drive_cell_empty");

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        ICellModelRegistry cellRegistry = Api.instance().client().cells();
        IdentityHashMap<Item, IBakedModel> cellModels = new IdentityHashMap<Item, IBakedModel>();
        for (Map.Entry<Item, ResourceLocation> entry : cellRegistry.models().entrySet()) {
            IBakedModel cellModel = bakery.getBakedModel(entry.getValue(), modelTransform, spriteGetter);
            cellModels.put(entry.getKey(), cellModel);
        }
        IBakedModel baseModel = bakery.getBakedModel(MODEL_BASE, modelTransform, spriteGetter);
        IBakedModel defaultCell = bakery.getBakedModel(cellRegistry.getDefaultModel(), modelTransform, spriteGetter);
        cellModels.put(Items.field_190931_a, bakery.getBakedModel(MODEL_CELL_EMPTY, modelTransform, spriteGetter));
        return new DriveBakedModel(baseModel, cellModels, defaultCell);
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return Collections.emptyList();
    }
}

