/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.model.RenderHelper;
import appeng.decorative.solid.GlassState;
import appeng.decorative.solid.QuartzGlassBlock;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

class GlassBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<GlassState> GLASS_STATE = new ModelProperty();
    private static final byte[][][] OFFSETS = GlassBakedModel.generateOffsets();
    static final Material TEXTURE_A = new Material(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2:block/glass/quartz_glass_a"));
    static final Material TEXTURE_B = new Material(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2:block/glass/quartz_glass_b"));
    static final Material TEXTURE_C = new Material(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2:block/glass/quartz_glass_c"));
    static final Material TEXTURE_D = new Material(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2:block/glass/quartz_glass_d"));
    static final Material[] TEXTURES_FRAME = GlassBakedModel.generateTexturesFrame();
    private final TextureAtlasSprite[] glassTextures;
    private final TextureAtlasSprite[] frameTextures;

    private static Material[] generateTexturesFrame() {
        return (Material[])IntStream.range(1, 16).mapToObj(Integer::toBinaryString).map(s -> Strings.padStart((String)s, (int)4, (char)'0')).map(s -> new ResourceLocation("appliedenergistics2:block/glass/quartz_glass_frame" + s)).map(rl -> new Material(AtlasTexture.field_110575_b, rl)).toArray(Material[]::new);
    }

    public GlassBakedModel(Function<Material, TextureAtlasSprite> bakedTextureGetter) {
        this.glassTextures = new TextureAtlasSprite[]{bakedTextureGetter.apply(TEXTURE_A), bakedTextureGetter.apply(TEXTURE_B), bakedTextureGetter.apply(TEXTURE_C), bakedTextureGetter.apply(TEXTURE_D)};
        this.frameTextures = new TextureAtlasSprite[16];
        for (int i = 0; i < TEXTURES_FRAME.length; ++i) {
            this.frameTextures[1 + i] = bakedTextureGetter.apply(TEXTURES_FRAME[i]);
        }
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        if (side == null) {
            return Collections.emptyList();
        }
        GlassState glassState = (GlassState)extraData.getData(GLASS_STATE);
        if (glassState == null) {
            return Collections.emptyList();
        }
        int cx = Math.abs(glassState.getX() % 10);
        int cy = Math.abs(glassState.getY() % 10);
        int cz = Math.abs(glassState.getZ() % 10);
        int u = OFFSETS[cx][cy][cz] % 4;
        int v = OFFSETS[9 - cx][9 - cy][9 - cz] % 4;
        int texIdx = Math.abs((OFFSETS[cx][cy][cz] + (glassState.getX() + glassState.getY() + glassState.getZ())) % 4);
        if (texIdx < 2) {
            u /= 2;
            v /= 2;
        }
        TextureAtlasSprite glassTexture = this.glassTextures[texIdx];
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(5);
        List<Vec3d> corners = RenderHelper.getFaceCorners(side);
        quads.add(this.createQuad(side, corners, glassTexture, u, v));
        int edgeBitmask = GlassBakedModel.makeBitmask(glassState, side);
        TextureAtlasSprite sideSprite = this.frameTextures[edgeBitmask];
        if (sideSprite != null) {
            quads.add(this.createQuad(side, corners, sideSprite, 0.0f, 0.0f));
        }
        return quads;
    }

    public boolean func_230044_c_() {
        return false;
    }

    private static int makeBitmask(GlassState state, Direction side) {
        switch (side) {
            case DOWN: {
                return GlassBakedModel.makeBitmask(state, Direction.SOUTH, Direction.EAST, Direction.NORTH, Direction.WEST);
            }
            case UP: {
                return GlassBakedModel.makeBitmask(state, Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST);
            }
            case NORTH: {
                return GlassBakedModel.makeBitmask(state, Direction.UP, Direction.WEST, Direction.DOWN, Direction.EAST);
            }
            case SOUTH: {
                return GlassBakedModel.makeBitmask(state, Direction.UP, Direction.EAST, Direction.DOWN, Direction.WEST);
            }
            case WEST: {
                return GlassBakedModel.makeBitmask(state, Direction.UP, Direction.SOUTH, Direction.DOWN, Direction.NORTH);
            }
            case EAST: {
                return GlassBakedModel.makeBitmask(state, Direction.UP, Direction.NORTH, Direction.DOWN, Direction.SOUTH);
            }
        }
        throw new IllegalArgumentException("Unsupported side!");
    }

    private static int makeBitmask(GlassState state, Direction up, Direction right, Direction down, Direction left) {
        int bitmask = 0;
        if (!state.isFlushWith(up)) {
            bitmask |= 1;
        }
        if (!state.isFlushWith(right)) {
            bitmask |= 2;
        }
        if (!state.isFlushWith(down)) {
            bitmask |= 4;
        }
        if (!state.isFlushWith(left)) {
            bitmask |= 8;
        }
        return bitmask;
    }

    private BakedQuad createQuad(Direction side, List<Vec3d> corners, TextureAtlasSprite sprite, float uOffset, float vOffset) {
        return this.createQuad(side, corners.get(0), corners.get(1), corners.get(2), corners.get(3), sprite, uOffset, vOffset);
    }

    private BakedQuad createQuad(Direction side, Vec3d c1, Vec3d c2, Vec3d c3, Vec3d c4, TextureAtlasSprite sprite, float uOffset, float vOffset) {
        Vec3d normal = new Vec3d(side.func_176730_m());
        float u1 = MathHelper.func_76131_a((float)(0.0f - uOffset), (float)0.0f, (float)16.0f);
        float u2 = MathHelper.func_76131_a((float)(16.0f - uOffset), (float)0.0f, (float)16.0f);
        float v1 = MathHelper.func_76131_a((float)(0.0f - vOffset), (float)0.0f, (float)16.0f);
        float v2 = MathHelper.func_76131_a((float)(16.0f - vOffset), (float)0.0f, (float)16.0f);
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(side);
        this.putVertex(builder, normal, c1.field_72450_a, c1.field_72448_b, c1.field_72449_c, sprite, u1, v1);
        this.putVertex(builder, normal, c2.field_72450_a, c2.field_72448_b, c2.field_72449_c, sprite, u1, v2);
        this.putVertex(builder, normal, c3.field_72450_a, c3.field_72448_b, c3.field_72449_c, sprite, u2, v2);
        this.putVertex(builder, normal, c4.field_72450_a, c4.field_72448_b, c4.field_72449_c, sprite, u2, v1);
        return builder.build();
    }

    private void putVertex(BakedQuadBuilder builder, Vec3d normal, double x, double y, double z, TextureAtlasSprite sprite, float u, float v) {
        VertexFormat vertexFormat = builder.getVertexFormat();
        block6: for (int e = 0; e < vertexFormat.func_227894_c_().size(); ++e) {
            VertexFormatElement el = (VertexFormatElement)vertexFormat.func_227894_c_().get(e);
            switch (el.func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f});
                    continue block6;
                }
                case UV: {
                    if (el.func_177369_e() == 0) {
                        u = sprite.func_94214_a((double)u);
                        v = sprite.func_94207_b((double)v);
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.frameTextures[this.frameTextures.length - 1];
    }

    private static byte[][][] generateOffsets() {
        Random r = new Random(924L);
        byte[][][] offset = new byte[10][10][10];
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 10; ++y) {
                r.nextBytes(offset[x][y]);
            }
        }
        return offset;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull ILightReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        EnumSet<Direction> flushWith = EnumSet.noneOf(Direction.class);
        for (Direction facing : Direction.values()) {
            if (!GlassBakedModel.isGlassBlock((IBlockReader)world, pos, facing)) continue;
            flushWith.add(facing);
        }
        GlassState glassState = new GlassState(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), flushWith);
        return new ModelDataMap.Builder().withInitial(GLASS_STATE, (Object)glassState).build();
    }

    private static boolean isGlassBlock(IBlockReader world, BlockPos pos, Direction facing) {
        return world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() instanceof QuartzGlassBlock;
    }
}

