/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;

final class MatrixVertexTransformer
extends QuadGatheringTransformer {
    private final Matrix4f transform;

    public MatrixVertexTransformer(Matrix4f transform) {
        this.transform = transform;
    }

    protected void processQuad() {
        VertexFormat format = this.parent.getVertexFormat();
        ImmutableList elements = format.func_227894_c_();
        int count = elements.size();
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < count; ++e) {
                VertexFormatElement element = (VertexFormatElement)elements.get(e);
                if (element.func_177375_c() == VertexFormatElement.Usage.POSITION) {
                    this.parent.put(e, this.transform(this.quadData[e][v], element.func_177370_d()));
                    continue;
                }
                if (element.func_177375_c() == VertexFormatElement.Usage.NORMAL) {
                    this.parent.put(e, this.transformNormal(this.quadData[e][v]));
                    continue;
                }
                this.parent.put(e, this.quadData[e][v]);
            }
        }
    }

    public void setQuadTint(int tint) {
        this.parent.setQuadTint(tint);
    }

    public void setQuadOrientation(Direction orientation) {
        this.parent.setQuadOrientation(orientation);
    }

    public void setApplyDiffuseLighting(boolean diffuse) {
        this.parent.setApplyDiffuseLighting(diffuse);
    }

    public void setTexture(TextureAtlasSprite texture) {
        this.parent.setTexture(texture);
    }

    private float[] transform(float[] fs, int elemCount) {
        switch (fs.length) {
            case 3: {
                Vector4f vec = new Vector4f(fs[0], fs[1], fs[2], 1.0f);
                vec.setX(vec.func_195910_a() - 0.5f);
                vec.setY(vec.func_195913_b() - 0.5f);
                vec.setZ(vec.func_195914_c() - 0.5f);
                vec.func_229372_a_(this.transform);
                vec.setX(vec.func_195910_a() + 0.5f);
                vec.setY(vec.func_195913_b() + 0.5f);
                vec.setZ(vec.func_195914_c() + 0.5f);
                return new float[]{vec.func_195910_a(), vec.func_195913_b(), vec.func_195914_c()};
            }
            case 4: {
                Vector4f vecc = new Vector4f(fs[0], fs[1], fs[2], fs[3]);
                if (elemCount == 3) {
                    vecc.setW(1.0f);
                }
                vecc.setX(vecc.func_195910_a() - 0.5f);
                vecc.setY(vecc.func_195913_b() - 0.5f);
                vecc.setZ(vecc.func_195914_c() - 0.5f);
                vecc.func_229372_a_(this.transform);
                vecc.setX(vecc.func_195910_a() + 0.5f);
                vecc.setY(vecc.func_195913_b() + 0.5f);
                vecc.setZ(vecc.func_195914_c() + 0.5f);
                return new float[]{vecc.func_195910_a(), vecc.func_195913_b(), vecc.func_195914_c(), vecc.func_195915_d()};
            }
        }
        return fs;
    }

    private float[] transformNormal(float[] fs) {
        switch (fs.length) {
            case 3: {
                Vector4f normal = new Vector4f(fs[0], fs[1], fs[2], 0.0f);
                normal.func_229372_a_(this.transform);
                normal.func_229374_e_();
                return new float[]{normal.func_195910_a(), normal.func_195913_b(), normal.func_195914_c()};
            }
            case 4: {
                Vector4f normal = new Vector4f(fs[0], fs[1], fs[2], fs[3]);
                normal.func_229372_a_(this.transform);
                normal.func_229374_e_();
                return new float[]{normal.func_195910_a(), normal.func_195913_b(), normal.func_195914_c(), normal.func_195915_d()};
            }
        }
        return fs;
    }
}

