/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.common.model.TransformationHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class UVLModelLoader
implements IModelLoader<UVLModelWrapper> {
    public static final UVLModelLoader INSTANCE = new UVLModelLoader();
    final Gson UVLSERIALIZER = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new ModelLoaderRegistry.ExpandedBlockModelDeserializer()).registerTypeAdapter(BlockPart.class, (Object)new BlockPart.Deserializer()).registerTypeAdapter(BlockPartFace.class, (Object)new BlockPartFaceOverrideSerializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransformVec3f.class, (Object)new ItemTransformVec3f.Deserializer()).registerTypeAdapter(ItemCameraTransforms.class, (Object)new ItemCameraTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).registerTypeAdapter(TransformationMatrix.class, (Object)new TransformationHelper.Deserializer()).create();

    public void func_195410_a(IResourceManager resourceManager) {
    }

    public UVLModelWrapper read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        modelContents.remove("loader");
        BlockModel blockModel = (BlockModel)this.UVLSERIALIZER.fromJson((JsonElement)modelContents, BlockModel.class);
        return new UVLModelWrapper(blockModel);
    }

    public static class UVLModelWrapper
    implements IModelGeometry<UVLModelWrapper> {
        private final BlockModel parent;

        public UVLModelWrapper(BlockModel parent) {
            this.parent = parent;
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            TextureAtlasSprite particle = spriteGetter.apply(owner.resolveTexture("particle"));
            IModelBuilder builder = IModelBuilder.of((IModelConfiguration)owner, (ItemOverrideList)overrides, (TextureAtlasSprite)particle);
            for (BlockPart blockpart : this.parent.func_178298_a()) {
                for (Direction direction : blockpart.field_178240_c.keySet()) {
                    BlockPartFace blockpartface = (BlockPartFace)blockpart.field_178240_c.get(direction);
                    TextureAtlasSprite textureatlassprite1 = spriteGetter.apply(owner.resolveTexture(blockpartface.field_178242_d));
                    BakedQuad quad = BlockModel.makeBakedQuad((BlockPart)blockpart, (BlockPartFace)blockpartface, (TextureAtlasSprite)textureatlassprite1, (Direction)direction, (IModelTransform)modelTransform, (ResourceLocation)modelLocation);
                    if (blockpartface instanceof BlockPartFaceWithUVL) {
                        BlockPartFaceWithUVL uvlFace = (BlockPartFaceWithUVL)blockpartface;
                        quad = this.applyPreBakedLighting(quad, textureatlassprite1, uvlFace.sky, uvlFace.block);
                    }
                    if (blockpartface.field_178244_b == null) {
                        builder.addGeneralQuad(quad);
                        continue;
                    }
                    builder.addFaceQuad(modelTransform.func_225615_b_().rotateTransform(blockpartface.field_178244_b), quad);
                }
            }
            return builder.build();
        }

        private BakedQuad applyPreBakedLighting(BakedQuad quad, TextureAtlasSprite sprite, final float sky, final float block) {
            BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
            VertexLighterFlat trans = new VertexLighterFlat(Minecraft.func_71410_x().func_184125_al()){

                protected void updateLightmap(float[] normal, float[] lightmap, float x, float y, float z) {
                    lightmap[0] = block;
                    lightmap[1] = sky;
                }

                public void setQuadTint(int tint) {
                }
            };
            MatrixStack identity = new MatrixStack();
            trans.setTransform(identity.func_227866_c_());
            trans.setParent((IVertexConsumer)builder);
            quad.pipe((IVertexConsumer)trans);
            builder.setQuadTint(quad.func_178211_c());
            builder.setQuadOrientation(quad.func_178210_d());
            builder.setApplyDiffuseLighting(false);
            return builder.build();
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<com.mojang.datafixers.util.Pair<String, String>> missingTextureErrors) {
            return this.parent.func_225614_a_(modelGetter, missingTextureErrors);
        }
    }

    private static class BlockPartFaceWithUVL
    extends BlockPartFace {
        private final float sky;
        private final float block;

        public BlockPartFaceWithUVL(@Nullable Direction cullFaceIn, int tintIndexIn, String textureIn, BlockFaceUV blockFaceUVIn, float sky, float block) {
            super(cullFaceIn, tintIndexIn, textureIn, blockFaceUVIn);
            this.sky = sky;
            this.block = block;
        }

        public float getSky() {
            return this.sky;
        }

        public float getBlock() {
            return this.block;
        }
    }

    private static class BlockPartFaceOverrideSerializer
    extends BlockPartFace.Deserializer {
        private BlockPartFaceOverrideSerializer() {
        }

        public BlockPartFace deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            BlockPartFace blockFace = super.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
            Pair<Float, Float> uvl = this.parseUVL(p_deserialize_1_.getAsJsonObject());
            if (uvl != null) {
                return new BlockPartFaceWithUVL(blockFace.field_178244_b, blockFace.field_178245_c, blockFace.field_178242_d, blockFace.field_178243_e, ((Float)uvl.getLeft()).floatValue(), ((Float)uvl.getRight()).floatValue());
            }
            return blockFace;
        }

        protected Pair<Float, Float> parseUVL(JsonObject object) {
            if (!object.has("uvlightmap")) {
                return null;
            }
            object = object.get("uvlightmap").getAsJsonObject();
            return new ImmutablePair((Object)Float.valueOf(JSONUtils.func_151221_a((JsonObject)object, (String)"sky", (float)0.0f)), (Object)Float.valueOf(JSONUtils.func_151221_a((JsonObject)object, (String)"block", (float)0.0f)));
        }
    }
}

