/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.spatial;

import appeng.client.render.cablebus.CubeBuilder;
import appeng.client.render.spatial.SpatialPylonTextureType;
import appeng.tile.spatial.SpatialPylonTileEntity;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

class SpatialPylonBakedModel
implements IDynamicBakedModel {
    private final Map<SpatialPylonTextureType, TextureAtlasSprite> textures;

    SpatialPylonBakedModel(Map<SpatialPylonTextureType, TextureAtlasSprite> textures) {
        this.textures = ImmutableMap.copyOf(textures);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        int flags = this.getFlags(extraData);
        CubeBuilder builder = new CubeBuilder();
        if (flags != 0) {
            Direction ori = null;
            int displayAxis = flags & 0xC;
            if (displayAxis == 4) {
                ori = Direction.EAST;
                if ((flags & 3) == 2) {
                    builder.setUvRotation(Direction.SOUTH, 1);
                    builder.setUvRotation(Direction.NORTH, 1);
                    builder.setUvRotation(Direction.UP, 2);
                    builder.setUvRotation(Direction.DOWN, 2);
                } else if ((flags & 3) == 1) {
                    builder.setUvRotation(Direction.SOUTH, 2);
                    builder.setUvRotation(Direction.NORTH, 2);
                    builder.setUvRotation(Direction.UP, 1);
                    builder.setUvRotation(Direction.DOWN, 1);
                } else {
                    builder.setUvRotation(Direction.SOUTH, 1);
                    builder.setUvRotation(Direction.NORTH, 1);
                    builder.setUvRotation(Direction.UP, 1);
                    builder.setUvRotation(Direction.DOWN, 1);
                }
            } else if (displayAxis == 8) {
                ori = Direction.UP;
                if ((flags & 3) == 2) {
                    builder.setUvRotation(Direction.NORTH, 3);
                    builder.setUvRotation(Direction.SOUTH, 3);
                    builder.setUvRotation(Direction.EAST, 3);
                    builder.setUvRotation(Direction.WEST, 3);
                }
            } else if (displayAxis == 12) {
                ori = Direction.NORTH;
                if ((flags & 3) == 2) {
                    builder.setUvRotation(Direction.EAST, 2);
                    builder.setUvRotation(Direction.WEST, 1);
                } else if ((flags & 3) == 1) {
                    builder.setUvRotation(Direction.EAST, 1);
                    builder.setUvRotation(Direction.WEST, 2);
                    builder.setUvRotation(Direction.UP, 3);
                    builder.setUvRotation(Direction.DOWN, 3);
                } else {
                    builder.setUvRotation(Direction.EAST, 1);
                    builder.setUvRotation(Direction.WEST, 2);
                }
            }
            builder.setTextures(this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideOutside(flags, ori, Direction.UP)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideOutside(flags, ori, Direction.DOWN)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideOutside(flags, ori, Direction.NORTH)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideOutside(flags, ori, Direction.SOUTH)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideOutside(flags, ori, Direction.EAST)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideOutside(flags, ori, Direction.WEST)));
            builder.addCube(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f);
            if ((flags & 0x20) == 32) {
                builder.setRenderFullBright(true);
            }
            builder.setTextures(this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideInside(flags, ori, Direction.UP)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideInside(flags, ori, Direction.DOWN)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideInside(flags, ori, Direction.NORTH)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideInside(flags, ori, Direction.SOUTH)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideInside(flags, ori, Direction.EAST)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideInside(flags, ori, Direction.WEST)));
            builder.addCube(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f);
        } else {
            builder.setTexture(this.textures.get((Object)SpatialPylonTextureType.BASE));
            builder.addCube(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f);
            builder.setTexture(this.textures.get((Object)SpatialPylonTextureType.DIM));
            builder.addCube(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f);
        }
        return builder.getOutput();
    }

    private int getFlags(IModelData modelData) {
        Integer flags = (Integer)modelData.getData(SpatialPylonTileEntity.STATE);
        return flags != null ? flags : 0;
    }

    private static SpatialPylonTextureType getTextureTypeFromSideOutside(int flags, Direction ori, Direction dir) {
        if (ori == dir || ori.func_176734_d() == dir) {
            return SpatialPylonTextureType.BASE;
        }
        if ((flags & 3) == 3) {
            return SpatialPylonTextureType.BASE_SPANNED;
        }
        if ((flags & 3) == 1) {
            return SpatialPylonTextureType.BASE_END;
        }
        if ((flags & 3) == 2) {
            return SpatialPylonTextureType.BASE_END;
        }
        return SpatialPylonTextureType.BASE;
    }

    private static SpatialPylonTextureType getTextureTypeFromSideInside(int flags, Direction ori, Direction dir) {
        boolean good;
        boolean bl = good = (flags & 0x10) == 16;
        if (ori == dir || ori.func_176734_d() == dir) {
            return good ? SpatialPylonTextureType.DIM : SpatialPylonTextureType.RED;
        }
        if ((flags & 3) == 3) {
            return good ? SpatialPylonTextureType.DIM_SPANNED : SpatialPylonTextureType.RED_SPANNED;
        }
        if ((flags & 3) == 1) {
            return good ? SpatialPylonTextureType.DIM_END : SpatialPylonTextureType.RED_END;
        }
        if ((flags & 3) == 2) {
            return good ? SpatialPylonTextureType.DIM_END : SpatialPylonTextureType.RED_END;
        }
        return SpatialPylonTextureType.BASE;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.textures.get((Object)SpatialPylonTextureType.DIM);
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

