/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.spatial;

import appeng.client.render.spatial.SpatialPylonBakedModel;
import appeng.client.render.spatial.SpatialPylonTextureType;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class SpatialPylonModel
implements IModelGeometry<SpatialPylonModel> {
    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        EnumMap<SpatialPylonTextureType, TextureAtlasSprite> textures = new EnumMap<SpatialPylonTextureType, TextureAtlasSprite>(SpatialPylonTextureType.class);
        for (SpatialPylonTextureType type : SpatialPylonTextureType.values()) {
            textures.put(type, spriteGetter.apply(SpatialPylonModel.getTexturePath(type)));
        }
        return new SpatialPylonBakedModel(textures);
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return Arrays.stream(SpatialPylonTextureType.values()).map(SpatialPylonModel::getTexturePath).collect(Collectors.toList());
    }

    private static Material getTexturePath(SpatialPylonTextureType type) {
        return new Material(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2", "block/spatial_pylon/" + type.name().toLowerCase()));
    }
}

