/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.tesr;

import appeng.block.storage.DriveSlotState;
import appeng.client.render.FacingToRotation;
import appeng.tile.storage.DriveTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.EnumMap;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DriveLedTileEntityRenderer
extends TileEntityRenderer<DriveTileEntity> {
    private static final EnumMap<DriveSlotState, Vector3f> STATE_COLORS;
    private static final Vector3f BLINK_COLOR;
    private static final float L = 0.875f;
    private static final float R = 0.8125f;
    private static final float T = 0.875f;
    private static final float B = 0.8124375f;
    private static final float FR = 0.0624375f;
    private static final float BA = 0.0936875f;
    private static final float[] LED_QUADS;
    private static final RenderType STATE;

    public DriveLedTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(DriveTileEntity drive, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffers, int combinedLightIn, int combinedOverlayIn) {
        if (drive.getCellCount() != 10) {
            throw new IllegalStateException("Expected drive to have 10 slots");
        }
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 0.5, 0.5);
        FacingToRotation.get(drive.getForward(), drive.getUp()).push(ms);
        ms.func_227861_a_(-0.5, -0.5, -0.5);
        IVertexBuilder buffer = buffers.getBuffer(STATE);
        for (int row = 0; row < 5; ++row) {
            for (int col = 0; col < 2; ++col) {
                int slot = row * 2 + col;
                Vector3f color = this.getColorForSlot(drive, slot, partialTicks);
                if (color == null) continue;
                ms.func_227860_a_();
                float xOffset = (float)(-col * 8) / 16.0f;
                float yOffset = (float)(-row * 3) / 16.0f;
                ms.func_227861_a_((double)xOffset, (double)yOffset, 0.0);
                for (int i = 0; i < LED_QUADS.length; i += 3) {
                    float x = LED_QUADS[i];
                    float y = LED_QUADS[i + 1];
                    float z = LED_QUADS[i + 2];
                    buffer.func_227888_a_(ms.func_227866_c_().func_227870_a_(), x, y, z).func_227885_a_(color.func_195899_a(), color.func_195900_b(), color.func_195902_c(), 1.0f).func_181675_d();
                }
                ms.func_227865_b_();
            }
        }
        ms.func_227865_b_();
    }

    private Vector3f getColorForSlot(DriveTileEntity drive, int slot, float partialTicks) {
        DriveSlotState state = DriveSlotState.fromCellStatus(drive.getCellStatus(slot));
        if (state == DriveSlotState.EMPTY) {
            return null;
        }
        if (!drive.isPowered()) {
            return STATE_COLORS.get((Object)DriveSlotState.OFFLINE);
        }
        Vector3f col = STATE_COLORS.get((Object)state);
        if (drive.isCellBlinking(slot)) {
            long t = System.currentTimeMillis() % 200L;
            float f = (float)(t - 100L) / 200.0f + 0.5f;
            f = DriveLedTileEntityRenderer.easeInOutCubic(f);
            col = col.func_229195_e_();
            col.func_229190_a_(BLINK_COLOR, f);
        }
        return col;
    }

    private static float easeInOutCubic(float x) {
        return x < 0.5f ? 4.0f * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0f;
    }

    static {
        BLINK_COLOR = new Vector3f(1.0f, 0.5f, 0.5f);
        STATE_COLORS = new EnumMap(DriveSlotState.class);
        STATE_COLORS.put(DriveSlotState.OFFLINE, new Vector3f(0.0f, 0.0f, 0.0f));
        STATE_COLORS.put(DriveSlotState.ONLINE, new Vector3f(0.0f, 1.0f, 0.0f));
        STATE_COLORS.put(DriveSlotState.NOT_EMPTY, new Vector3f(0.0f, 0.667f, 1.0f));
        STATE_COLORS.put(DriveSlotState.TYPES_FULL, new Vector3f(1.0f, 0.667f, 0.0f));
        STATE_COLORS.put(DriveSlotState.FULL, new Vector3f(1.0f, 0.0f, 0.0f));
        LED_QUADS = new float[]{0.8125f, 0.875f, 0.0624375f, 0.875f, 0.875f, 0.0624375f, 0.875f, 0.8124375f, 0.0624375f, 0.8125f, 0.8124375f, 0.0624375f, 0.875f, 0.875f, 0.0624375f, 0.875f, 0.875f, 0.0936875f, 0.875f, 0.8124375f, 0.0936875f, 0.875f, 0.8124375f, 0.0624375f, 0.8125f, 0.875f, 0.0936875f, 0.8125f, 0.875f, 0.0624375f, 0.8125f, 0.8124375f, 0.0624375f, 0.8125f, 0.8124375f, 0.0936875f, 0.8125f, 0.875f, 0.0936875f, 0.875f, 0.875f, 0.0936875f, 0.875f, 0.875f, 0.0624375f, 0.8125f, 0.875f, 0.0624375f, 0.8125f, 0.8124375f, 0.0624375f, 0.875f, 0.8124375f, 0.0624375f, 0.875f, 0.8124375f, 0.0936875f, 0.8125f, 0.8124375f, 0.0936875f};
        STATE = RenderType.func_228633_a_((String)"ae_drive_leds", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)32565, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228728_a_(false));
    }
}

