/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.tesr;

import appeng.api.features.InscriberProcessType;
import appeng.client.render.FacingToRotation;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.tile.misc.InscriberTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.items.IItemHandler;

public final class InscriberTESR
extends TileEntityRenderer<InscriberTileEntity> {
    private static final float ITEM_RENDER_SCALE = 0.8333333f;
    private static final Material TEXTURE_INSIDE = new Material(PlayerContainer.field_226615_c_, new ResourceLocation("appliedenergistics2", "block/inscriber_inside"));
    private static final ResourceLocation TAG_STORAGE_BLOCKS = new ResourceLocation("forge:storage_blocks");

    public InscriberTESR(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(InscriberTileEntity tile, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffers, int combinedLight, int combinedOverlay) {
        boolean renderPresses;
        float relativeProgress;
        float progress;
        long currentTime;
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 0.5, 0.5);
        FacingToRotation.get(tile.getForward(), tile.getUp()).push(ms);
        ms.func_227861_a_(-0.5, -0.5, -0.5);
        long absoluteProgress = 0L;
        if (tile.isSmash() && (absoluteProgress = (currentTime = System.currentTimeMillis()) - tile.getClientStart()) > 800L) {
            tile.setSmash(false);
        }
        progress = (progress = (relativeProgress = (float)(absoluteProgress % 800L) / 400.0f)) > 1.0f ? 1.0f - InscriberTESR.easeDecompressMotion(progress - 1.0f) : InscriberTESR.easeCompressMotion(progress);
        float press = 0.2f;
        press -= progress / 5.0f;
        float middle = 0.5f;
        float TwoPx = 0.125f;
        float base = 0.4f;
        TextureAtlasSprite tas = TEXTURE_INSIDE.func_229314_c_();
        IVertexBuilder buffer = buffers.getBuffer(RenderType.func_228639_c_());
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, (middle += 0.02f) + press, 0.125f, 2.0, 13.0, combinedOverlay, combinedLight, Direction.DOWN);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, middle + press, 0.125f, 14.0, 13.0, combinedOverlay, combinedLight, Direction.DOWN);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, middle + press, 0.875f, 14.0, 2.0, combinedOverlay, combinedLight, Direction.DOWN);
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, middle + press, 0.875f, 2.0, 2.0, combinedOverlay, combinedLight, Direction.DOWN);
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, middle + 0.4f, 0.125f, 2.0, 3.0f - 16.0f * (press - 0.4f), combinedOverlay, combinedLight, Direction.NORTH);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, middle + 0.4f, 0.125f, 14.0, 3.0f - 16.0f * (press - 0.4f), combinedOverlay, combinedLight, Direction.NORTH);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, middle + press, 0.125f, 14.0, 3.0, combinedOverlay, combinedLight, Direction.NORTH);
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, middle + press, 0.125f, 2.0, 3.0, combinedOverlay, combinedLight, Direction.NORTH);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, (middle -= 0.04f) - press, 0.125f, 2.0, 13.0, combinedOverlay, combinedLight, Direction.UP);
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, middle - press, 0.125f, 14.0, 13.0, combinedOverlay, combinedLight, Direction.UP);
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, middle - press, 0.875f, 14.0, 2.0, combinedOverlay, combinedLight, Direction.UP);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, middle - press, 0.875f, 2.0, 2.0, combinedOverlay, combinedLight, Direction.UP);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, middle + -0.4f, 0.125f, 2.0, 3.0f - 16.0f * (press - 0.4f), combinedOverlay, combinedLight, Direction.NORTH);
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, middle - 0.4f, 0.125f, 14.0, 3.0f - 16.0f * (press - 0.4f), combinedOverlay, combinedLight, Direction.NORTH);
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, middle - press, 0.125f, 14.0, 3.0, combinedOverlay, combinedLight, Direction.NORTH);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, middle - press, 0.125f, 2.0, 3.0, combinedOverlay, combinedLight, Direction.NORTH);
        IItemHandler tileInv = tile.getInternalInventory();
        int items = 0;
        if (!tileInv.getStackInSlot(0).func_190926_b()) {
            ++items;
        }
        if (!tileInv.getStackInSlot(1).func_190926_b()) {
            ++items;
        }
        if (!tileInv.getStackInSlot(2).func_190926_b()) {
            ++items;
        }
        if (relativeProgress > 1.0f || items == 0) {
            InscriberRecipe ir;
            renderPresses = false;
            ItemStack is = tileInv.getStackInSlot(3);
            if (is.func_190926_b() && (ir = tile.getTask()) != null) {
                renderPresses = ir.getProcessType() == InscriberProcessType.INSCRIBE;
                is = ir.getOutput().func_77946_l();
            }
            this.renderItem(ms, is, 0.0f, buffers, combinedLight, combinedOverlay);
        } else {
            renderPresses = true;
            this.renderItem(ms, tileInv.getStackInSlot(2), 0.0f, buffers, combinedLight, combinedOverlay);
        }
        if (renderPresses) {
            this.renderItem(ms, tileInv.getStackInSlot(0), press, buffers, combinedLight, combinedOverlay);
            this.renderItem(ms, tileInv.getStackInSlot(1), -press, buffers, combinedLight, combinedOverlay);
        }
        ms.func_227865_b_();
    }

    private static void addVertex(IVertexBuilder vb, MatrixStack ms, TextureAtlasSprite sprite, float x, float y, float z, double texU, double texV, int overlayUV, int lightmapUV, Direction front) {
        vb.func_227888_a_(ms.func_227866_c_().func_227870_a_(), x, y, z);
        vb.func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f);
        vb.func_225583_a_(sprite.func_94214_a(texU), sprite.func_94207_b(texV));
        vb.func_227891_b_(overlayUV);
        vb.func_227886_a_(lightmapUV);
        vb.func_227887_a_(ms.func_227866_c_().func_227872_b_(), (float)front.func_82601_c(), (float)front.func_96559_d(), (float)front.func_82599_e());
        vb.func_181675_d();
    }

    private void renderItem(MatrixStack ms, ItemStack stack, float o, IRenderTypeBuffer buffers, int combinedLight, int combinedOverlay) {
        if (!stack.func_190926_b()) {
            ms.func_227860_a_();
            ms.func_227861_a_(0.5, (double)(0.5f + o), 0.5);
            ms.func_227863_a_(new Quaternion(90.0f, 0.0f, 0.0f, true));
            ms.func_227862_a_(0.8333333f, 0.8333333f, 0.8333333f);
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            if (!stack.func_77973_b().getTags().contains(TAG_STORAGE_BLOCKS)) {
                ms.func_227862_a_(0.5f, 0.5f, 0.5f);
            }
            itemRenderer.func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, combinedLight, combinedOverlay, ms, buffers);
            ms.func_227865_b_();
        }
    }

    public static void registerTexture(TextureStitchEvent.Pre evt) {
        if (evt.getMap().func_229223_g_().equals((Object)TEXTURE_INSIDE.func_229310_a_())) {
            evt.addSprite(TEXTURE_INSIDE.func_229313_b_());
        }
    }

    private static float easeCompressMotion(float x) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return (float)(1.0 + (double)c3 * Math.pow(x - 1.0f, 3.0) + (double)c1 * Math.pow(x - 1.0f, 2.0));
    }

    private static float easeDecompressMotion(float x) {
        return x * x * x * x * x;
    }
}

