/*
 * Decompiled with CFR 0.152.
 */
package appeng.container;

import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.parts.AEBasePart;
import com.google.common.base.Preconditions;
import io.netty.handler.codec.DecoderException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;

public final class ContainerLocator {
    private final Type type;
    private final int itemIndex;
    private final int dimensionId;
    private final BlockPos blockPos;
    private final AEPartLocation side;

    private ContainerLocator(Type type, int itemIndex, int dimensionId, BlockPos blockPos, AEPartLocation side) {
        this.type = type;
        this.itemIndex = itemIndex;
        this.dimensionId = dimensionId;
        this.blockPos = blockPos;
        this.side = side;
    }

    public static ContainerLocator forTileEntity(TileEntity te) {
        if (te.func_145831_w() == null) {
            throw new IllegalArgumentException("Cannot open a tile entity that is not in a world");
        }
        int dimensionId = te.func_145831_w().func_201675_m().func_186058_p().func_186068_a();
        return new ContainerLocator(Type.BLOCK, -1, dimensionId, te.func_174877_v(), null);
    }

    public static ContainerLocator forTileEntitySide(TileEntity te, Direction side) {
        if (te.func_145831_w() == null) {
            throw new IllegalArgumentException("Cannot open a tile entity that is not in a world");
        }
        int dimensionId = te.func_145831_w().func_201675_m().func_186058_p().func_186068_a();
        return new ContainerLocator(Type.PART, -1, dimensionId, te.func_174877_v(), AEPartLocation.fromFacing(side));
    }

    public static ContainerLocator forItemUseContext(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            throw new IllegalArgumentException("Cannot open a container without a player");
        }
        int dimensionId = player.field_70170_p.func_201675_m().func_186058_p().func_186068_a();
        int slot = ContainerLocator.getPlayerInventorySlotFromHand(player, context.func_221531_n());
        AEPartLocation side = AEPartLocation.fromFacing(context.func_196000_l());
        return new ContainerLocator(Type.PLAYER_INVENTORY_WITH_BLOCK_CONTEXT, slot, dimensionId, context.func_195995_a(), side);
    }

    public static ContainerLocator forHand(PlayerEntity player, Hand hand) {
        int slot = ContainerLocator.getPlayerInventorySlotFromHand(player, hand);
        return new ContainerLocator(Type.PLAYER_INVENTORY, slot, -1, null, null);
    }

    private static int getPlayerInventorySlotFromHand(PlayerEntity player, Hand hand) {
        ItemStack is = player.func_184586_b(hand);
        if (is.func_190926_b()) {
            throw new IllegalArgumentException("Cannot open an item-inventory with empty hands");
        }
        int invSize = player.field_71071_by.func_70302_i_();
        for (int i = 0; i < invSize; ++i) {
            if (player.field_71071_by.func_70301_a(i) != is) continue;
            return i;
        }
        throw new IllegalArgumentException("Could not find item held in hand " + hand + " in player inventory");
    }

    public static ContainerLocator forPart(AEBasePart part) {
        IPartHost host = part.getHost();
        DimensionalCoord pos = host.getLocation();
        return new ContainerLocator(Type.PART, -1, pos.getWorld().func_201675_m().func_186058_p().func_186068_a(), pos.getBlockPos(), part.getSide());
    }

    public boolean hasItemIndex() {
        return this.type == Type.PLAYER_INVENTORY || this.type == Type.PLAYER_INVENTORY_WITH_BLOCK_CONTEXT;
    }

    public int getItemIndex() {
        Preconditions.checkState((boolean)this.hasItemIndex());
        return this.itemIndex;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public boolean hasBlockPos() {
        return this.type == Type.BLOCK || this.type == Type.PART || this.type == Type.PLAYER_INVENTORY_WITH_BLOCK_CONTEXT;
    }

    public BlockPos getBlockPos() {
        Preconditions.checkState((boolean)this.hasBlockPos());
        return this.blockPos;
    }

    public boolean hasSide() {
        return this.type == Type.PART || this.type == Type.PLAYER_INVENTORY_WITH_BLOCK_CONTEXT;
    }

    public AEPartLocation getSide() {
        Preconditions.checkState((boolean)this.hasSide());
        return this.side;
    }

    public void write(PacketBuffer buf) {
        switch (this.type) {
            case PLAYER_INVENTORY: {
                buf.writeByte(0);
                buf.writeInt(this.itemIndex);
                break;
            }
            case PLAYER_INVENTORY_WITH_BLOCK_CONTEXT: {
                buf.writeByte(1);
                buf.writeInt(this.itemIndex);
                buf.writeInt(this.dimensionId);
                buf.func_179255_a(this.blockPos);
                buf.writeByte(this.side.ordinal());
                break;
            }
            case BLOCK: {
                buf.writeByte(2);
                buf.writeInt(this.dimensionId);
                buf.func_179255_a(this.blockPos);
                break;
            }
            case PART: {
                buf.writeByte(3);
                buf.writeInt(this.dimensionId);
                buf.func_179255_a(this.blockPos);
                buf.writeByte(this.side.ordinal());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported ContainerLocator type: " + (Object)((Object)this.type));
            }
        }
    }

    public static ContainerLocator read(PacketBuffer buf) {
        byte type = buf.readByte();
        switch (type) {
            case 0: {
                return new ContainerLocator(Type.PLAYER_INVENTORY, buf.readInt(), -1, null, null);
            }
            case 1: {
                return new ContainerLocator(Type.PLAYER_INVENTORY_WITH_BLOCK_CONTEXT, buf.readInt(), buf.readInt(), buf.func_179259_c(), AEPartLocation.values()[buf.readByte()]);
            }
            case 2: {
                return new ContainerLocator(Type.BLOCK, -1, buf.readInt(), buf.func_179259_c(), null);
            }
            case 3: {
                return new ContainerLocator(Type.PART, -1, buf.readInt(), buf.func_179259_c(), AEPartLocation.values()[buf.readByte()]);
            }
        }
        throw new DecoderException("ContainerLocator type out of range: " + type);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.type.name());
        result.append('{');
        if (this.hasItemIndex()) {
            result.append("slot=").append(this.itemIndex).append(',');
        }
        if (this.hasBlockPos()) {
            result.append("dim=").append(this.dimensionId).append(',');
            result.append("pos=").append(this.blockPos).append(',');
        }
        if (this.hasSide()) {
            result.append("side=").append((Object)this.side).append(',');
        }
        if (result.charAt(result.length() - 1) == ',') {
            result.setLength(result.length() - 1);
        }
        result.append('}');
        return result.toString();
    }

    private static enum Type {
        PLAYER_INVENTORY,
        PLAYER_INVENTORY_WITH_BLOCK_CONTEXT,
        BLOCK,
        PART;

    }
}

