/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.FullnessMode;
import appeng.api.config.OperationMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.tile.storage.IOPortTileEntity;
import appeng.util.Platform;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;

public class IOPortContainer
extends UpgradeableContainer {
    public static ContainerType<IOPortContainer> TYPE;
    private static final ContainerHelper<IOPortContainer, IOPortTileEntity> helper;
    @GuiSync(value=2)
    public FullnessMode fMode = FullnessMode.EMPTY;
    @GuiSync(value=3)
    public OperationMode opMode = OperationMode.EMPTY;

    public static IOPortContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public IOPortContainer(int id, PlayerInventory ip, IOPortTileEntity te) {
        super(TYPE, id, ip, te);
    }

    @Override
    protected int getHeight() {
        return 166;
    }

    @Override
    protected void setupConfig() {
        int x;
        int y;
        int offX = 19;
        int offY = 17;
        IItemHandler cells = this.getUpgradeable().getInventoryByName("cells");
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 2; ++x) {
                this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.STORAGE_CELLS, cells, x + y * 2, offX + x * 18, offY + y * 18, this.getPlayerInventory()));
            }
        }
        offX = 122;
        offY = 17;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 2; ++x) {
                this.func_75146_a(new OutputSlot(cells, 6 + x + y * 2, offX + x * 18, offY + y * 18, RestrictedInputSlot.PlacableItemType.STORAGE_CELLS.IIcon));
            }
        }
        IItemHandler upgrades = this.getUpgradeable().getInventoryByName("upgrades");
        this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 0, 187, 8, this.getPlayerInventory()).setNotDraggable());
        this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 1, 187, 26, this.getPlayerInventory()).setNotDraggable());
        this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 2, 187, 44, this.getPlayerInventory()).setNotDraggable());
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 3;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.setOperationMode((OperationMode)this.getUpgradeable().getConfigManager().getSetting(Settings.OPERATION_MODE));
            this.setFullMode((FullnessMode)this.getUpgradeable().getConfigManager().getSetting(Settings.FULLNESS_MODE));
            this.setRedStoneMode((RedstoneMode)this.getUpgradeable().getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED));
        }
        this.standardDetectAndSendChanges();
    }

    public FullnessMode getFullMode() {
        return this.fMode;
    }

    private void setFullMode(FullnessMode fMode) {
        this.fMode = fMode;
    }

    public OperationMode getOperationMode() {
        return this.opMode;
    }

    private void setOperationMode(OperationMode opMode) {
        this.opMode = opMode;
    }

    static {
        helper = new ContainerHelper<IOPortContainer, IOPortTileEntity>(IOPortContainer::new, IOPortTileEntity.class, SecurityPermissions.BUILD);
    }
}

