/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.util.IConfigManager;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.slot.FakeSlot;
import appeng.container.slot.NormalSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;

public class InterfaceContainer
extends UpgradeableContainer {
    public static ContainerType<InterfaceContainer> TYPE;
    private static final ContainerHelper<InterfaceContainer, IInterfaceHost> helper;
    private final DualityInterface myDuality;
    @GuiSync(value=3)
    public YesNo bMode = YesNo.NO;
    @GuiSync(value=4)
    public YesNo iTermMode = YesNo.YES;

    public static InterfaceContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public InterfaceContainer(int id, PlayerInventory ip, IInterfaceHost te) {
        super(TYPE, id, ip, te.getInterfaceDuality().getHost());
        int x;
        this.myDuality = te.getInterfaceDuality();
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, this.myDuality.getPatterns(), x, 8 + 18 * x, 97, this.getPlayerInventory()));
        }
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new FakeSlot(this.myDuality.getConfig(), x, 8 + 18 * x, 35));
        }
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new NormalSlot(this.myDuality.getStorage(), x, 8 + 18 * x, 53));
        }
    }

    @Override
    protected int getHeight() {
        return 211;
    }

    @Override
    protected void setupConfig() {
        this.setupUpgrades();
    }

    @Override
    public int availableUpgrades() {
        return 1;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        super.func_75142_b();
    }

    @Override
    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setBlockingMode((YesNo)cm.getSetting(Settings.BLOCK));
        this.setInterfaceTerminalMode((YesNo)cm.getSetting(Settings.INTERFACE_TERMINAL));
    }

    public YesNo getBlockingMode() {
        return this.bMode;
    }

    private void setBlockingMode(YesNo bMode) {
        this.bMode = bMode;
    }

    public YesNo getInterfaceTerminalMode() {
        return this.iTermMode;
    }

    private void setInterfaceTerminalMode(YesNo iTermMode) {
        this.iTermMode = iTermMode;
    }

    static {
        helper = new ContainerHelper<InterfaceContainer, IInterfaceHost>(InterfaceContainer::new, IInterfaceHost.class, SecurityPermissions.BUILD);
    }
}

