/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.LevelType;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.slot.FakeTypeOnlySlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.parts.automation.LevelEmitterPart;
import appeng.util.Platform;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;

public class LevelEmitterContainer
extends UpgradeableContainer {
    public static ContainerType<LevelEmitterContainer> TYPE;
    private static final ContainerHelper<LevelEmitterContainer, LevelEmitterPart> helper;
    private final LevelEmitterPart lvlEmitter;
    @OnlyIn(value=Dist.CLIENT)
    private TextFieldWidget textField;
    @GuiSync(value=2)
    public LevelType lvType;
    @GuiSync(value=3)
    public long EmitterValue = -1L;
    @GuiSync(value=4)
    public YesNo cmType;

    public static LevelEmitterContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public LevelEmitterContainer(int id, PlayerInventory ip, LevelEmitterPart te) {
        super(TYPE, id, ip, te);
        this.lvlEmitter = te;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setTextField(TextFieldWidget level) {
        this.textField = level;
        this.textField.func_146180_a(String.valueOf(this.EmitterValue));
    }

    public void setLevel(long l, PlayerEntity player) {
        this.lvlEmitter.setReportingValue(l);
        this.EmitterValue = l;
    }

    @Override
    protected void setupConfig() {
        IItemHandler upgrades = this.getUpgradeable().getInventoryByName("upgrades");
        if (this.availableUpgrades() > 0) {
            this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 0, 187, 8, this.getPlayerInventory()).setNotDraggable());
        }
        if (this.availableUpgrades() > 1) {
            this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 1, 187, 26, this.getPlayerInventory()).setNotDraggable());
        }
        if (this.availableUpgrades() > 2) {
            this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 2, 187, 44, this.getPlayerInventory()).setNotDraggable());
        }
        if (this.availableUpgrades() > 3) {
            this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 3, 187, 62, this.getPlayerInventory()).setNotDraggable());
        }
        IItemHandler inv = this.getUpgradeable().getInventoryByName("config");
        int y = 40;
        int x = 124;
        this.func_75146_a(new FakeTypeOnlySlot(inv, 0, 124, 40));
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 1;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.EmitterValue = this.lvlEmitter.getReportingValue();
            this.setCraftingMode((YesNo)this.getUpgradeable().getConfigManager().getSetting(Settings.CRAFT_VIA_REDSTONE));
            this.setLevelMode((LevelType)this.getUpgradeable().getConfigManager().getSetting(Settings.LEVEL_TYPE));
            this.setFuzzyMode((FuzzyMode)this.getUpgradeable().getConfigManager().getSetting(Settings.FUZZY_MODE));
            this.setRedStoneMode((RedstoneMode)this.getUpgradeable().getConfigManager().getSetting(Settings.REDSTONE_EMITTER));
        }
        this.standardDetectAndSendChanges();
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("EmitterValue") && this.textField != null) {
            this.textField.func_146180_a(String.valueOf(this.EmitterValue));
        }
    }

    @Override
    public YesNo getCraftingMode() {
        return this.cmType;
    }

    @Override
    public void setCraftingMode(YesNo cmType) {
        this.cmType = cmType;
    }

    public LevelType getLevelMode() {
        return this.lvType;
    }

    private void setLevelMode(LevelType lvType) {
        this.lvType = lvType;
    }

    static {
        helper = new ContainerHelper<LevelEmitterContainer, LevelEmitterPart>(LevelEmitterContainer::new, LevelEmitterPart.class, SecurityPermissions.BUILD);
    }
}

