/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.crafting.ICraftingHelper;
import appeng.api.definitions.IDefinitions;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerLocator;
import appeng.container.ContainerNull;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.slot.FakeCraftingMatrixSlot;
import appeng.container.slot.FakeSlot;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalFakeSlot;
import appeng.container.slot.PatternOutputsSlot;
import appeng.container.slot.PatternTermSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.Api;
import appeng.core.sync.packets.PatternSlotPacket;
import appeng.helpers.IContainerCraftingPacket;
import appeng.items.storage.ViewCellItem;
import appeng.me.helpers.MachineSource;
import appeng.parts.reporting.PatternTerminalPart;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public class PatternTermContainer
extends MEMonitorableContainer
implements IAEAppEngInventory,
IOptionalSlotHost,
IContainerCraftingPacket {
    public static ContainerType<PatternTermContainer> TYPE;
    private static final ContainerHelper<PatternTermContainer, ITerminalHost> helper;
    private final PatternTerminalPart patternTerminal;
    private final AppEngInternalInventory cOut = new AppEngInternalInventory(null, 1);
    private final IItemHandler crafting;
    private final FakeCraftingMatrixSlot[] craftingSlots = new FakeCraftingMatrixSlot[9];
    private final OptionalFakeSlot[] outputSlots = new OptionalFakeSlot[3];
    private final PatternTermSlot craftSlot;
    private final RestrictedInputSlot patternSlotIN;
    private final RestrictedInputSlot patternSlotOUT;
    private final ICraftingHelper craftingHelper = Api.INSTANCE.crafting();
    private ICraftingRecipe currentRecipe;
    @GuiSync(value=97)
    public boolean craftingMode = true;
    @GuiSync(value=96)
    public boolean substitute = false;

    public static PatternTermContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public PatternTermContainer(int id, PlayerInventory ip, ITerminalHost monitorable) {
        super(TYPE, id, ip, monitorable, false);
        int y;
        this.patternTerminal = (PatternTerminalPart)monitorable;
        IItemHandler patternInv = this.getPatternTerminal().getInventoryByName("pattern");
        IItemHandler output = this.getPatternTerminal().getInventoryByName("output");
        this.crafting = this.getPatternTerminal().getInventoryByName("crafting");
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                FakeCraftingMatrixSlot fakeCraftingMatrixSlot = new FakeCraftingMatrixSlot(this.crafting, x + y * 3, 18 + x * 18, -76 + y * 18);
                this.craftingSlots[x + y * 3] = fakeCraftingMatrixSlot;
                this.func_75146_a(fakeCraftingMatrixSlot);
            }
        }
        this.craftSlot = new PatternTermSlot(ip.field_70458_d, this.getActionSource(), this.getPowerSource(), monitorable, this.crafting, patternInv, (IItemHandler)this.cOut, 110, -58, this, 2, this);
        this.func_75146_a(this.craftSlot);
        this.craftSlot.setIIcon(-1);
        for (y = 0; y < 3; ++y) {
            this.outputSlots[y] = new PatternOutputsSlot(output, this, y, 110, -76 + y * 18, 0, 0, 1);
            this.func_75146_a(this.outputSlots[y]);
            this.outputSlots[y].setRenderDisabled(false);
            this.outputSlots[y].setIIcon(-1);
        }
        this.patternSlotIN = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BLANK_PATTERN, patternInv, 0, 147, -81, this.getPlayerInventory());
        this.func_75146_a(this.patternSlotIN);
        this.patternSlotOUT = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, patternInv, 1, 147, -38, this.getPlayerInventory());
        this.func_75146_a(this.patternSlotOUT);
        this.patternSlotOUT.setStackLimit(1);
        this.bindPlayerInventory(ip, 0, 0);
        this.updateOrderOfOutputSlots();
    }

    private void updateOrderOfOutputSlots() {
        if (!this.isCraftingMode()) {
            this.craftSlot.field_75223_e = -9000;
            for (int y = 0; y < 3; ++y) {
                this.outputSlots[y].field_75223_e = this.outputSlots[y].getX();
            }
        } else {
            this.craftSlot.field_75223_e = this.craftSlot.getX();
            for (int y = 0; y < 3; ++y) {
                this.outputSlots[y].field_75223_e = -9000;
            }
        }
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        super.func_75141_a(slotID, stack);
        this.getAndUpdateOutput();
    }

    private ItemStack getAndUpdateOutput() {
        World world = this.getPlayerInv().field_70458_d.field_70170_p;
        CraftingInventory ic = new CraftingInventory((Container)this, 3, 3);
        for (int x = 0; x < ic.func_70302_i_(); ++x) {
            ic.func_70299_a(x, this.crafting.getStackInSlot(x));
        }
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a((IInventory)ic, world)) {
            this.currentRecipe = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)ic, world).orElse(null);
        }
        ItemStack is = this.currentRecipe == null ? ItemStack.field_190927_a : this.currentRecipe.func_77572_b((IInventory)ic);
        this.cOut.setStackInSlot(0, is);
        return is;
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    public void encode() {
        ItemStack output = this.patternSlotOUT.func_75211_c();
        ItemStack[] in = this.getInputs();
        ItemStack[] out = this.getOutputs();
        if (in == null || out == null || this.isCraftingMode() && this.currentRecipe == null) {
            return;
        }
        if (!output.func_190926_b() && !this.craftingHelper.isEncodedPattern(output)) {
            return;
        }
        if (output.func_190926_b()) {
            output = this.patternSlotIN.func_75211_c();
            if (output.func_190926_b() || !this.isPattern(output)) {
                return;
            }
            output.func_190920_e(output.func_190916_E() - 1);
            if (output.func_190916_E() == 0) {
                this.patternSlotIN.func_75215_d(ItemStack.field_190927_a);
            }
            output = null;
        }
        output = this.isCraftingMode() ? this.craftingHelper.encodeCraftingPattern(output, this.currentRecipe, in, out[0], this.isSubstitute()) : this.craftingHelper.encodeProcessingPattern(output, in, out);
        this.patternSlotOUT.func_75215_d(output);
    }

    private ItemStack[] getInputs() {
        ItemStack[] input = new ItemStack[9];
        boolean hasValue = false;
        for (int x = 0; x < this.craftingSlots.length; ++x) {
            input[x] = this.craftingSlots[x].func_75211_c();
            if (input[x].func_190926_b()) continue;
            hasValue = true;
        }
        if (hasValue) {
            return input;
        }
        return null;
    }

    private ItemStack[] getOutputs() {
        if (this.isCraftingMode()) {
            ItemStack out = this.getAndUpdateOutput();
            if (!out.func_190926_b() && out.func_190916_E() > 0) {
                return new ItemStack[]{out};
            }
        } else {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(3);
            boolean hasValue = false;
            for (OptionalFakeSlot outputSlot : this.outputSlots) {
                ItemStack out = outputSlot.func_75211_c();
                if (out.func_190926_b() || out.func_190916_E() <= 0) continue;
                list.add(out);
                hasValue = true;
            }
            if (hasValue) {
                return list.toArray(new ItemStack[list.size()]);
            }
        }
        return null;
    }

    private boolean isPattern(ItemStack output) {
        if (output.func_190926_b()) {
            return false;
        }
        IDefinitions definitions = Api.instance().definitions();
        return definitions.materials().blankPattern().isSameAs(output);
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        if (idx == 1) {
            return Platform.isServer() ? !this.getPatternTerminal().isCraftingRecipe() : !this.isCraftingMode();
        }
        if (idx == 2) {
            return Platform.isServer() ? this.getPatternTerminal().isCraftingRecipe() : this.isCraftingMode();
        }
        return false;
    }

    public void craftOrGetItem(PatternSlotPacket packetPatternSlot) {
        if (packetPatternSlot.slotItem != null && this.getCellInventory() != null) {
            IAEItemStack out = packetPatternSlot.slotItem.copy();
            InventoryAdaptor inv = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(this.getPlayerInv().field_70458_d.field_71071_by));
            InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor(this.getPlayerInv().field_70458_d);
            if (packetPatternSlot.shift) {
                inv = playerInv;
            }
            if (!inv.simulateAdd(out.createItemStack()).func_190926_b()) {
                return;
            }
            IAEItemStack extracted = Platform.poweredExtraction(this.getPowerSource(), this.getCellInventory(), out, this.getActionSource());
            PlayerEntity p = this.getPlayerInv().field_70458_d;
            if (extracted != null) {
                inv.addItems(extracted.createItemStack());
                if (p instanceof ServerPlayerEntity) {
                    this.updateHeld((ServerPlayerEntity)p);
                }
                this.func_75142_b();
                return;
            }
            CraftingInventory ic = new CraftingInventory((Container)new ContainerNull(), 3, 3);
            CraftingInventory real = new CraftingInventory((Container)new ContainerNull(), 3, 3);
            for (int x = 0; x < 9; ++x) {
                ic.func_70299_a(x, packetPatternSlot.pattern[x] == null ? ItemStack.field_190927_a : packetPatternSlot.pattern[x].createItemStack());
            }
            IRecipe r = p.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)ic, p.field_70170_p).orElse(null);
            if (r == null) {
                return;
            }
            IMEMonitor<IAEItemStack> storage = this.getPatternTerminal().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IItemList<IAEItemStack> all = storage.getStorageList();
            ItemStack is = r.func_77572_b((IInventory)ic);
            for (int x = 0; x < ic.func_70302_i_(); ++x) {
                if (ic.func_70301_a(x).func_190926_b()) continue;
                ItemStack pulled = Platform.extractItemsByRecipe(this.getPowerSource(), this.getActionSource(), storage, p.field_70170_p, (IRecipe<CraftingInventory>)r, is, ic, ic.func_70301_a(x), x, all, Actionable.MODULATE, ViewCellItem.createFilter(this.getViewCells()));
                real.func_70299_a(x, pulled);
            }
            IRecipe rr = p.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)real, p.field_70170_p).orElse(null);
            if (rr == r && Platform.itemComparisons().isSameItem(rr.func_77572_b((IInventory)real), is)) {
                CraftResultInventory craftingResult = new CraftResultInventory();
                craftingResult.func_193056_a(rr);
                CraftingResultSlot sc = new CraftingResultSlot(p, real, (IInventory)craftingResult, 0, 0, 0);
                sc.func_190901_a(p, is);
                for (int x = 0; x < real.func_70302_i_(); ++x) {
                    ItemStack failed = playerInv.addItems(real.func_70301_a(x));
                    if (failed.func_190926_b()) continue;
                    p.func_71019_a(failed, false);
                }
                inv.addItems(is);
                if (p instanceof ServerPlayerEntity) {
                    this.updateHeld((ServerPlayerEntity)p);
                }
                this.func_75142_b();
            } else {
                for (int x = 0; x < real.func_70302_i_(); ++x) {
                    ItemStack failed = real.func_70301_a(x);
                    if (failed.func_190926_b()) continue;
                    this.getCellInventory().injectItems(AEItemStack.fromItemStack(failed), Actionable.MODULATE, new MachineSource(this.getPatternTerminal()));
                }
            }
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (Platform.isServer()) {
            if (this.isCraftingMode() != this.getPatternTerminal().isCraftingRecipe()) {
                this.setCraftingMode(this.getPatternTerminal().isCraftingRecipe());
                this.updateOrderOfOutputSlots();
            }
            this.substitute = this.patternTerminal.isSubstitution();
        }
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (field.equals("craftingMode")) {
            this.getAndUpdateOutput();
            this.updateOrderOfOutputSlots();
        }
    }

    @Override
    public void onSlotChange(Slot s) {
        if (s == this.patternSlotOUT && Platform.isServer()) {
            for (IContainerListener listener : this.field_75149_d) {
                for (Slot slot : this.field_75151_b) {
                    if (!(slot instanceof OptionalFakeSlot) && !(slot instanceof FakeCraftingMatrixSlot)) continue;
                    listener.func_71111_a((Container)this, slot.field_75222_d, slot.func_75211_c());
                }
                if (!(listener instanceof ServerPlayerEntity)) continue;
                ((ServerPlayerEntity)listener).field_71137_h = false;
            }
            this.func_75142_b();
        }
        if (s == this.craftSlot && Platform.isClient()) {
            this.getAndUpdateOutput();
        }
    }

    public void clear() {
        for (FakeCraftingMatrixSlot fakeCraftingMatrixSlot : this.craftingSlots) {
            fakeCraftingMatrixSlot.func_75215_d(ItemStack.field_190927_a);
        }
        for (FakeSlot fakeSlot : this.outputSlots) {
            fakeSlot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
        this.getAndUpdateOutput();
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("player")) {
            return new PlayerInvWrapper(this.getPlayerInventory());
        }
        return this.getPatternTerminal().getInventoryByName(name);
    }

    @Override
    public boolean useRealItems() {
        return false;
    }

    public void toggleSubstitute() {
        this.substitute = !this.substitute;
        this.func_75142_b();
        this.getAndUpdateOutput();
    }

    public boolean isCraftingMode() {
        return this.craftingMode;
    }

    private void setCraftingMode(boolean craftingMode) {
        this.craftingMode = craftingMode;
    }

    public PatternTerminalPart getPatternTerminal() {
        return this.patternTerminal;
    }

    private boolean isSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(boolean substitute) {
        this.substitute = substitute;
    }

    static {
        helper = new ContainerHelper<PatternTermContainer, ITerminalHost>(PatternTermContainer::new, ITerminalHost.class, SecurityPermissions.CRAFT);
    }
}

