/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.parts.IPart;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.helpers.IPriorityHost;
import appeng.util.Platform;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PriorityContainer
extends AEBaseContainer {
    public static ContainerType<PriorityContainer> TYPE;
    private static final ContainerHelper<PriorityContainer, IPriorityHost> helper;
    private final IPriorityHost priHost;
    @OnlyIn(value=Dist.CLIENT)
    private TextFieldWidget textField;
    @GuiSync(value=2)
    public long PriorityValue = -1L;

    public static PriorityContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public PriorityContainer(int id, PlayerInventory ip, IPriorityHost te) {
        super(TYPE, id, ip, (TileEntity)(te instanceof TileEntity ? te : null), (IPart)((Object)(te instanceof IPart ? te : null)));
        this.priHost = te;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setTextField(TextFieldWidget level) {
        this.textField = level;
        this.textField.func_146180_a(String.valueOf(this.PriorityValue));
    }

    public void setPriority(int newValue, PlayerEntity player) {
        this.priHost.setPriority(newValue);
        this.PriorityValue = newValue;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.PriorityValue = this.priHost.getPriority();
        }
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("PriorityValue") && this.textField != null) {
            this.textField.func_146180_a(String.valueOf(this.PriorityValue));
        }
        super.onUpdate(field, oldValue, newValue);
    }

    public IPriorityHost getPriorityHost() {
        return this.priHost;
    }

    static {
        helper = new ContainerHelper<PriorityContainer, IPriorityHost>(PriorityContainer::new, IPriorityHost.class, SecurityPermissions.BUILD);
    }
}

