/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.interfaces.IProgressProvider;
import appeng.container.slot.RestrictedInputSlot;
import appeng.tile.misc.VibrationChamberTileEntity;
import appeng.util.Platform;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;

public class VibrationChamberContainer
extends AEBaseContainer
implements IProgressProvider {
    public static ContainerType<VibrationChamberContainer> TYPE;
    private static final ContainerHelper<VibrationChamberContainer, VibrationChamberTileEntity> helper;
    private final VibrationChamberTileEntity vibrationChamber;
    @GuiSync(value=0)
    public int burnSpeed = 0;
    @GuiSync(value=1)
    public int remainingBurnTime = 0;

    public static VibrationChamberContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public VibrationChamberContainer(int id, PlayerInventory ip, VibrationChamberTileEntity vibrationChamber) {
        super(TYPE, id, ip, vibrationChamber, null);
        this.vibrationChamber = vibrationChamber;
        this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.FUEL, vibrationChamber.getInternalInventory(), 0, 80, 37, this.getPlayerInventory()));
        this.bindPlayerInventory(ip, 0, 84);
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer()) {
            this.remainingBurnTime = this.vibrationChamber.getMaxBurnTime() <= 0.0 ? 0 : (int)(100.0 * this.vibrationChamber.getBurnTime() / this.vibrationChamber.getMaxBurnTime());
            this.burnSpeed = this.remainingBurnTime <= 0 ? 0 : this.vibrationChamber.getBurnSpeed();
        }
        super.func_75142_b();
    }

    @Override
    public int getCurrentProgress() {
        return this.burnSpeed;
    }

    public int getRemainingBurnTime() {
        return this.remainingBurnTime;
    }

    @Override
    public int getMaxProgress() {
        return 200;
    }

    static {
        helper = new ContainerHelper<VibrationChamberContainer, VibrationChamberTileEntity>(VibrationChamberContainer::new, VibrationChamberTileEntity.class);
    }
}

