/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.config.CondenserOutput;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.config.YesNo;
import appeng.api.features.AEFeature;
import appeng.core.settings.TickRates;
import appeng.util.EnumCycler;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="appliedenergistics2", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class AEConfig {
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    private static final double DEFAULT_IC2_EXCHANGE = 2.0;
    private static final double DEFAULT_RF_EXCHANGE = 0.5;
    public static final String VERSION = "@version@";
    public static final String CHANNEL = "@aechannel@";
    private static final AEConfig instance;
    private final EnumSet<AEFeature> featureFlags = EnumSet.noneOf(AEFeature.class);
    private boolean removeCrashingItemsOnLoad;
    private int formationPlaneEntityLimit;
    private boolean enableEffects;
    private boolean useLargeFonts;
    private boolean useColoredCraftingStatus;
    private boolean disableColoredCableRecipesInJEI;
    private int craftingCalculationTimePerTick;
    private PowerUnits selectedPowerUnit;
    private final int[] craftByStacks = new int[4];
    private final int[] priorityByStacks = new int[4];
    private final int[] levelByStacks = new int[4];
    private final int[] levelByMillibuckets = new int[]{10, 100, 1000, 10000};
    private double spatialPowerExponent;
    private double spatialPowerMultiplier;
    private boolean spatialBlockTags;
    private float oreDoublePercentage;
    private int wirelessTerminalBattery;
    private int entropyManipulatorBattery;
    private int matterCannonBattery;
    private int portableCellBattery;
    private int colorApplicatorBattery;
    private int chargedStaffBattery;
    private int meteoriteMaximumSpawnHeight;
    private Set<String> meteoriteDimensionWhitelist;
    private double wirelessBaseCost;
    private double wirelessCostMultiplier;
    private double wirelessTerminalDrainMultiplier;
    private double wirelessBaseRange;
    private double wirelessBoosterRangeMultiplier;
    private double wirelessBoosterExp;
    private double wirelessHighWirelessCount;
    public static final double TUNNEL_POWER_LOSS = 0.05;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            instance.syncClientConfig();
        } else if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            instance.syncCommonConfig();
        }
    }

    private void syncClientConfig() {
        this.disableColoredCableRecipesInJEI = (Boolean)AEConfig.CLIENT.disableColoredCableRecipesInJEI.get();
        this.enableEffects = (Boolean)AEConfig.CLIENT.enableEffects.get();
        this.useLargeFonts = (Boolean)AEConfig.CLIENT.useLargeFonts.get();
        this.useColoredCraftingStatus = (Boolean)AEConfig.CLIENT.useColoredCraftingStatus.get();
        this.selectedPowerUnit = (PowerUnits)((Object)AEConfig.CLIENT.selectedPowerUnit.get());
        for (int btnNum = 0; btnNum < 4; ++btnNum) {
            this.craftByStacks[btnNum] = (Integer)AEConfig.CLIENT.craftByStacks.get(btnNum).get();
            this.priorityByStacks[btnNum] = (Integer)AEConfig.CLIENT.priorityByStacks.get(btnNum).get();
            this.levelByStacks[btnNum] = (Integer)AEConfig.CLIENT.levelByStacks.get(btnNum).get();
        }
    }

    private void syncCommonConfig() {
        PowerUnits.EU.conversionRatio = (Double)AEConfig.COMMON.powerRatioIc2.get();
        PowerUnits.RF.conversionRatio = (Double)AEConfig.COMMON.powerRatioForgeEnergy.get();
        PowerMultiplier.CONFIG.multiplier = (Double)AEConfig.COMMON.powerUsageMultiplier.get();
        CondenserOutput.MATTER_BALLS.requiredPower = (Integer)AEConfig.COMMON.condenserMatterBallsPower.get();
        CondenserOutput.SINGULARITY.requiredPower = (Integer)AEConfig.COMMON.condenserSingularityPower.get();
        this.oreDoublePercentage = ((Double)AEConfig.COMMON.oreDoublePercentage.get()).floatValue();
        this.meteoriteMaximumSpawnHeight = (Integer)AEConfig.COMMON.meteoriteMaximumSpawnHeight.get();
        this.meteoriteDimensionWhitelist = new HashSet<String>((Collection)AEConfig.COMMON.meteoriteDimensionWhitelist.get());
        this.wirelessBaseCost = (Double)AEConfig.COMMON.wirelessBaseCost.get();
        this.wirelessCostMultiplier = (Double)AEConfig.COMMON.wirelessCostMultiplier.get();
        this.wirelessBaseRange = (Double)AEConfig.COMMON.wirelessBaseRange.get();
        this.wirelessBoosterRangeMultiplier = (Double)AEConfig.COMMON.wirelessBoosterRangeMultiplier.get();
        this.wirelessBoosterExp = (Double)AEConfig.COMMON.wirelessBoosterExp.get();
        this.wirelessHighWirelessCount = (Double)AEConfig.COMMON.wirelessHighWirelessCount.get();
        this.wirelessTerminalDrainMultiplier = (Double)AEConfig.COMMON.wirelessTerminalDrainMultiplier.get();
        this.formationPlaneEntityLimit = (Integer)AEConfig.COMMON.formationPlaneEntityLimit.get();
        this.wirelessTerminalBattery = (Integer)AEConfig.COMMON.wirelessTerminalBattery.get();
        this.chargedStaffBattery = (Integer)AEConfig.COMMON.chargedStaffBattery.get();
        this.entropyManipulatorBattery = (Integer)AEConfig.COMMON.entropyManipulatorBattery.get();
        this.portableCellBattery = (Integer)AEConfig.COMMON.portableCellBattery.get();
        this.colorApplicatorBattery = (Integer)AEConfig.COMMON.colorApplicatorBattery.get();
        this.matterCannonBattery = (Integer)AEConfig.COMMON.matterCannonBattery.get();
        this.featureFlags.clear();
        for (AEFeature aEFeature : AEFeature.values()) {
            if (aEFeature.isVisible() && aEFeature.isConfig()) {
                if (!AEConfig.COMMON.enabledFeatures.containsKey((Object)aEFeature) || !((Boolean)AEConfig.COMMON.enabledFeatures.get((Object)aEFeature).get()).booleanValue()) continue;
                this.featureFlags.add(aEFeature);
                continue;
            }
            this.featureFlags.add(aEFeature);
        }
        for (Enum enum_ : TickRates.values()) {
            ((TickRates)enum_).setMin((Integer)AEConfig.COMMON.tickRateMin.get(enum_).get());
            ((TickRates)enum_).setMax((Integer)AEConfig.COMMON.tickRateMin.get(enum_).get());
        }
        this.spatialPowerMultiplier = (Double)AEConfig.COMMON.spatialPowerMultiplier.get();
        this.spatialPowerExponent = (Double)AEConfig.COMMON.spatialPowerExponent.get();
        this.spatialBlockTags = (Boolean)AEConfig.COMMON.spatialBlockTags.get();
        this.craftingCalculationTimePerTick = (Integer)AEConfig.COMMON.craftingCalculationTimePerTick.get();
        this.removeCrashingItemsOnLoad = (Boolean)AEConfig.COMMON.removeCrashingItemsOnLoad.get();
    }

    public static AEConfig instance() {
        return instance;
    }

    public boolean isFeatureEnabled(AEFeature f) {
        return !f.isConfig() && f.isEnabled() || this.featureFlags.contains((Object)f);
    }

    public boolean areFeaturesEnabled(Collection<AEFeature> features) {
        return this.featureFlags.containsAll(features);
    }

    public double wireless_getDrainRate(double range) {
        return this.wirelessTerminalDrainMultiplier * range;
    }

    public double wireless_getMaxRange(int boosters) {
        return this.wirelessBaseRange + this.wirelessBoosterRangeMultiplier * Math.pow(boosters, this.wirelessBoosterExp);
    }

    public double wireless_getPowerDrain(int boosters) {
        return this.wirelessBaseCost + this.wirelessCostMultiplier * Math.pow(boosters, 1.0 + (double)boosters / this.wirelessHighWirelessCount);
    }

    public YesNo getSearchTooltips() {
        return (YesNo)((Object)AEConfig.CLIENT.searchTooltips.get());
    }

    public TerminalStyle getTerminalStyle() {
        return (TerminalStyle)((Object)AEConfig.CLIENT.terminalStyle.get());
    }

    public void setTerminalStyle(TerminalStyle setting) {
        AEConfig.CLIENT.terminalStyle.set((Object)setting);
    }

    public SearchBoxMode getTerminalSearchMode() {
        return (SearchBoxMode)((Object)AEConfig.CLIENT.terminalSearchMode.get());
    }

    public void setTerminalSearchMode(SearchBoxMode setting) {
        AEConfig.CLIENT.terminalSearchMode.set((Object)setting);
    }

    public void save() {
        if (CLIENT_SPEC.isLoaded()) {
            AEConfig.CLIENT.selectedPowerUnit.set((Object)this.selectedPowerUnit);
            CLIENT_SPEC.save();
        }
        if (COMMON_SPEC.isLoaded()) {
            COMMON_SPEC.save();
        }
    }

    public int craftItemsByStackAmounts(int i) {
        return this.craftByStacks[i];
    }

    public int priorityByStacksAmounts(int i) {
        return this.priorityByStacks[i];
    }

    public int levelByStackAmounts(int i) {
        return this.levelByStacks[i];
    }

    public int levelByMillyBuckets(int i) {
        return this.levelByMillibuckets[i];
    }

    public PowerUnits getSelectedPowerUnit() {
        return this.selectedPowerUnit;
    }

    public void nextPowerUnit(boolean backwards) {
        this.selectedPowerUnit = (PowerUnits)EnumCycler.rotateEnum(this.selectedPowerUnit, backwards, Settings.POWER_UNITS.getPossibleValues());
        this.save();
    }

    public boolean isRemoveCrashingItemsOnLoad() {
        return this.removeCrashingItemsOnLoad;
    }

    public int getFormationPlaneEntityLimit() {
        return this.formationPlaneEntityLimit;
    }

    public boolean isEnableEffects() {
        return this.enableEffects;
    }

    public boolean isUseLargeFonts() {
        return this.useLargeFonts;
    }

    public boolean isUseColoredCraftingStatus() {
        return this.useColoredCraftingStatus;
    }

    public boolean isDisableColoredCableRecipesInJEI() {
        return this.disableColoredCableRecipesInJEI;
    }

    public int getCraftingCalculationTimePerTick() {
        return this.craftingCalculationTimePerTick;
    }

    public double getSpatialPowerExponent() {
        return this.spatialPowerExponent;
    }

    public double getSpatialPowerMultiplier() {
        return this.spatialPowerMultiplier;
    }

    public boolean getSpatialBlockTags() {
        return this.spatialBlockTags;
    }

    public float getOreDoublePercentage() {
        return this.oreDoublePercentage;
    }

    public DoubleSupplier getWirelessTerminalBattery() {
        return () -> this.wirelessTerminalBattery;
    }

    public DoubleSupplier getEntropyManipulatorBattery() {
        return () -> this.entropyManipulatorBattery;
    }

    public DoubleSupplier getMatterCannonBattery() {
        return () -> this.matterCannonBattery;
    }

    public DoubleSupplier getPortableCellBattery() {
        return () -> this.portableCellBattery;
    }

    public DoubleSupplier getColorApplicatorBattery() {
        return () -> this.colorApplicatorBattery;
    }

    public DoubleSupplier getChargedStaffBattery() {
        return () -> this.chargedStaffBattery;
    }

    public float getSpawnChargedChance() {
        return ((Double)AEConfig.COMMON.spawnChargedChance.get()).floatValue();
    }

    public int getQuartzOresPerCluster() {
        return (Integer)AEConfig.COMMON.quartzOresPerCluster.get();
    }

    public int getQuartzOresClusterAmount() {
        return (Integer)AEConfig.COMMON.quartzOresClusterAmount.get();
    }

    public int getMeteoriteMaximumSpawnHeight() {
        return this.meteoriteMaximumSpawnHeight;
    }

    public Set<String> getMeteoriteDimensionWhitelist() {
        return this.meteoriteDimensionWhitelist;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        Pair commonPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)commonPair.getRight();
        COMMON = (CommonConfig)commonPair.getLeft();
        instance = new AEConfig();
    }

    private static class CommonConfig {
        public final Map<AEFeature, ForgeConfigSpec.BooleanValue> enabledFeatures = new EnumMap<AEFeature, ForgeConfigSpec.BooleanValue>(AEFeature.class);
        public final ForgeConfigSpec.BooleanValue removeCrashingItemsOnLoad;
        public final ForgeConfigSpec.ConfigValue<Integer> formationPlaneEntityLimit;
        public final ForgeConfigSpec.ConfigValue<Integer> craftingCalculationTimePerTick;
        public final ForgeConfigSpec.ConfigValue<Double> spatialPowerExponent;
        public final ForgeConfigSpec.ConfigValue<Double> spatialPowerMultiplier;
        public final ForgeConfigSpec.ConfigValue<Boolean> spatialBlockTags;
        public final ForgeConfigSpec.DoubleValue oreDoublePercentage;
        public final ForgeConfigSpec.ConfigValue<Integer> wirelessTerminalBattery;
        public final ForgeConfigSpec.ConfigValue<Integer> entropyManipulatorBattery;
        public final ForgeConfigSpec.ConfigValue<Integer> matterCannonBattery;
        public final ForgeConfigSpec.ConfigValue<Integer> portableCellBattery;
        public final ForgeConfigSpec.ConfigValue<Integer> colorApplicatorBattery;
        public final ForgeConfigSpec.ConfigValue<Integer> chargedStaffBattery;
        public final ForgeConfigSpec.DoubleValue spawnChargedChance;
        public final ForgeConfigSpec.ConfigValue<Integer> quartzOresPerCluster;
        public final ForgeConfigSpec.ConfigValue<Integer> quartzOresClusterAmount;
        public final ForgeConfigSpec.ConfigValue<Integer> meteoriteMaximumSpawnHeight;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> meteoriteDimensionWhitelist;
        public final ForgeConfigSpec.ConfigValue<Double> wirelessBaseCost;
        public final ForgeConfigSpec.ConfigValue<Double> wirelessCostMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> wirelessTerminalDrainMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> wirelessBaseRange;
        public final ForgeConfigSpec.ConfigValue<Double> wirelessBoosterRangeMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> wirelessBoosterExp;
        public final ForgeConfigSpec.ConfigValue<Double> wirelessHighWirelessCount;
        public final ForgeConfigSpec.ConfigValue<Double> powerRatioIc2;
        public final ForgeConfigSpec.ConfigValue<Double> powerRatioForgeEnergy;
        public final ForgeConfigSpec.DoubleValue powerUsageMultiplier;
        public final ForgeConfigSpec.ConfigValue<Integer> condenserMatterBallsPower;
        public final ForgeConfigSpec.ConfigValue<Integer> condenserSingularityPower;
        public final Map<TickRates, ForgeConfigSpec.ConfigValue<Integer>> tickRateMin = new HashMap<TickRates, ForgeConfigSpec.ConfigValue<Integer>>();
        public final Map<TickRates, ForgeConfigSpec.ConfigValue<Integer>> tickRateMax = new HashMap<TickRates, ForgeConfigSpec.ConfigValue<Integer>>();

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Warning: Disabling a feature may disable other features depending on it.").push("features");
            Map<String, List<AEFeature>> groupedFeatures = Arrays.stream(AEFeature.values()).filter(AEFeature::isVisible).collect(Collectors.groupingBy(AEFeature::category));
            for (String category : groupedFeatures.keySet()) {
                List<AEFeature> featuresInGroup = groupedFeatures.get(category);
                builder.push(category);
                for (AEFeature feature : featuresInGroup) {
                    if (!feature.isConfig()) continue;
                    this.enabledFeatures.put(feature, builder.comment(Strings.nullToEmpty((String)feature.comment())).define(feature.key(), feature.isEnabled()));
                }
                builder.pop();
            }
            builder.pop();
            builder.push("general");
            this.removeCrashingItemsOnLoad = builder.comment("Will auto-remove items that crash when being loaded from storage. This will destroy those items instead of crashing the game!").define("removeCrashingItemsOnLoad", false);
            builder.pop();
            builder.push("automation");
            this.formationPlaneEntityLimit = builder.comment("TODO").define("formationPlaneEntityLimit", (Object)128);
            builder.pop();
            builder.push("craftingCPU");
            this.craftingCalculationTimePerTick = builder.define("craftingCalculationTimePerTick", (Object)5);
            builder.pop();
            builder.push("spatialio");
            this.spatialPowerMultiplier = builder.define("spatialPowerMultiplier", (Object)1250.0);
            this.spatialPowerExponent = builder.define("spatialPowerExponent", (Object)1.35);
            this.spatialBlockTags = builder.comment("BE CAREFUL, CAN CORRUPT YOUR WORLD! Will use #spatial/whitelist as whitelist.").define("spatialBlockTags", false);
            builder.pop();
            builder.push("GrindStone");
            this.oreDoublePercentage = builder.comment("Chance to actually get an output with stacksize > 1.").defineInRange("oreDoublePercentage", 90.0, 0.0, 100.0);
            builder.pop();
            builder.push("battery");
            this.wirelessTerminalBattery = builder.define("wirelessTerminal", (Object)1600000);
            this.chargedStaffBattery = builder.define("chargedStaff", (Object)8000);
            this.entropyManipulatorBattery = builder.define("entropyManipulator", (Object)200000);
            this.portableCellBattery = builder.define("portableCell", (Object)20000);
            this.colorApplicatorBattery = builder.define("colorApplicator", (Object)20000);
            this.matterCannonBattery = builder.define("matterCannon", (Object)200000);
            builder.pop();
            builder.push("worldGen");
            this.spawnChargedChance = builder.defineInRange("spawnChargedChance", 0.08, 0.0, 1.0);
            this.meteoriteMaximumSpawnHeight = builder.define("meteoriteMaximumSpawnHeight", (Object)180);
            ArrayList<String> defaultDimensionWhitelist = new ArrayList<String>();
            defaultDimensionWhitelist.add(DimensionType.func_212678_a((DimensionType)DimensionType.field_223227_a_).toString());
            this.meteoriteDimensionWhitelist = builder.defineList("meteoriteDimensionWhitelist", defaultDimensionWhitelist, obj -> true);
            this.quartzOresPerCluster = builder.define("quartzOresPerCluster", (Object)4);
            this.quartzOresClusterAmount = builder.define("quartzOresClusterAmount", (Object)20);
            builder.pop();
            builder.push("wireless");
            this.wirelessBaseCost = builder.define("wirelessBaseCost", (Object)8.0);
            this.wirelessCostMultiplier = builder.define("wirelessCostMultiplier", (Object)1.0);
            this.wirelessBaseRange = builder.define("wirelessBaseRange", (Object)16.0);
            this.wirelessBoosterRangeMultiplier = builder.define("wirelessBoosterRangeMultiplier", (Object)1.0);
            this.wirelessBoosterExp = builder.define("wirelessBoosterExp", (Object)1.5);
            this.wirelessHighWirelessCount = builder.define("wirelessHighWirelessCount", (Object)64.0);
            this.wirelessTerminalDrainMultiplier = builder.define("wirelessTerminalDrainMultiplier", (Object)1.0);
            builder.pop();
            builder.push("PowerRatios");
            this.powerRatioIc2 = builder.define("IC2", (Object)2.0);
            this.powerRatioForgeEnergy = builder.define("ForgeEnergy", (Object)0.5);
            this.powerUsageMultiplier = builder.defineInRange("UsageMultiplier", 1.0, 0.01, Double.MAX_VALUE);
            builder.pop();
            builder.push("Condenser");
            this.condenserMatterBallsPower = builder.define("MatterBalls", (Object)256);
            this.condenserSingularityPower = builder.define("Singularity", (Object)256000);
            builder.pop();
            builder.comment(" Min / Max Tickrates for dynamic ticking, most of these components also use sleeping, to prevent constant ticking, adjust with care, non standard rates are not supported or tested.").push("tickRates");
            for (TickRates tickRate : TickRates.values()) {
                this.tickRateMin.put(tickRate, (ForgeConfigSpec.ConfigValue<Integer>)builder.define(tickRate.name() + "Min", (Object)tickRate.getDefaultMin()));
                this.tickRateMax.put(tickRate, (ForgeConfigSpec.ConfigValue<Integer>)builder.define(tickRate.name() + "Max", (Object)tickRate.getDefaultMax()));
            }
            builder.pop();
        }
    }

    private static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue enableEffects;
        public final ForgeConfigSpec.BooleanValue useLargeFonts;
        public final ForgeConfigSpec.BooleanValue useColoredCraftingStatus;
        public final ForgeConfigSpec.BooleanValue disableColoredCableRecipesInJEI;
        public final ForgeConfigSpec.EnumValue<PowerUnits> selectedPowerUnit;
        private static final int[] BTN_BY_STACK_DEFAULTS = new int[]{1, 10, 100, 1000};
        public final List<ForgeConfigSpec.ConfigValue<Integer>> craftByStacks;
        public final List<ForgeConfigSpec.ConfigValue<Integer>> priorityByStacks;
        public final List<ForgeConfigSpec.ConfigValue<Integer>> levelByStacks;
        public final ForgeConfigSpec.EnumValue<YesNo> searchTooltips;
        public final ForgeConfigSpec.EnumValue<TerminalStyle> terminalStyle;
        public final ForgeConfigSpec.EnumValue<SearchBoxMode> terminalSearchMode;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            this.disableColoredCableRecipesInJEI = builder.comment("TODO").define("disableColoredCableRecipesInJEI", true);
            this.enableEffects = builder.comment("TODO").define("enableEffects", true);
            this.useLargeFonts = builder.comment("TODO").define("useTerminalUseLargeFont", false);
            this.useColoredCraftingStatus = builder.comment("TODO").define("useColoredCraftingStatus", true);
            this.selectedPowerUnit = builder.comment("Power unit shown in AE UIs").defineEnum("PowerUnit", (Enum)PowerUnits.AE, (Enum[])PowerUnits.values());
            this.craftByStacks = new ArrayList<ForgeConfigSpec.ConfigValue<Integer>>(4);
            this.priorityByStacks = new ArrayList<ForgeConfigSpec.ConfigValue<Integer>>(4);
            this.levelByStacks = new ArrayList<ForgeConfigSpec.ConfigValue<Integer>>(4);
            for (int btnNum = 0; btnNum < 4; ++btnNum) {
                int defaultValue = BTN_BY_STACK_DEFAULTS[btnNum];
                int buttonCap = (int)(Math.pow(10.0, btnNum + 1) - 1.0);
                this.craftByStacks.add((ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Controls buttons on Crafting Screen").defineInRange("craftByStacks" + btnNum, defaultValue, 1, buttonCap));
                this.priorityByStacks.add((ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Controls buttons on Priority Screen").defineInRange("priorityByStacks" + btnNum, defaultValue, 1, buttonCap));
                this.levelByStacks.add((ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Controls buttons on Level Emitter Screen").defineInRange("levelByStacks" + btnNum, defaultValue, 1, buttonCap));
            }
            builder.pop();
            builder.push("terminals");
            this.searchTooltips = builder.comment("Should tooltips be searched. Performance impact").defineEnum("searchTooltips", (Enum)YesNo.YES, (Enum[])YesNo.values());
            this.terminalStyle = builder.defineEnum("terminalStyle", (Enum)TerminalStyle.TALL, (Enum[])TerminalStyle.values());
            this.terminalSearchMode = builder.defineEnum("terminalSearchMode", (Enum)SearchBoxMode.AUTOSEARCH, (Enum[])SearchBoxMode.values());
            builder.pop();
        }
    }
}

